/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ChuteBlock
extends AbstractChuteBlock {
    public static final Property<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;

    public ChuteBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL))).func_206870_a((Property)FACING, (Comparable)Direction.DOWN));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CHUTE.create();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.func_177229_b((Property)FACING);
    }

    @Override
    public boolean isOpen(BlockState state) {
        return state.func_177229_b((Property)FACING) == Direction.DOWN || state.func_177229_b(SHAPE) == Shape.INTERSECTION;
    }

    @Override
    public boolean isTransparent(BlockState state) {
        return state.func_177229_b(SHAPE) == Shape.WINDOW;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        boolean down;
        Shape shape = (Shape)((Object)state.func_177229_b(SHAPE));
        boolean bl = down = state.func_177229_b((Property)FACING) == Direction.DOWN;
        if (!context.func_195991_k().field_72995_K && down && shape != Shape.INTERSECTION) {
            context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(shape == Shape.WINDOW ? Shape.NORMAL : Shape.WINDOW))));
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        Direction face = ctx.func_196000_l();
        if (face.func_176740_k().func_176722_c() && !ctx.func_225518_g_()) {
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            return this.updateChuteState((BlockState)state.func_206870_a((Property)FACING, (Comparable)face), world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos);
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_.func_206894_a(new Property[]{SHAPE, FACING}));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState above = world.func_180495_p(pos.func_177984_a());
        return !ChuteBlock.isChute(above) || ChuteBlock.getChuteFacing(above) == Direction.DOWN;
    }

    @Override
    public BlockState updateChuteState(BlockState state, BlockState above, IBlockReader world, BlockPos pos) {
        boolean noConnections;
        BlockState target;
        boolean vertical;
        if (!(state.func_177230_c() instanceof ChuteBlock)) {
            return state;
        }
        HashMap<BlockState, Boolean> connections = new HashMap<BlockState, Boolean>();
        int amtConnections = 0;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        boolean bl = vertical = facing == Direction.DOWN;
        if (!vertical && !ChuteBlock.isChute(target = world.func_180495_p(pos.func_177977_b().func_177972_a(facing.func_176734_d())))) {
            return (BlockState)((BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        for (BlockState direction : Iterate.horizontalDirections) {
            BlockState diagonalInputChute = world.func_180495_p(pos.func_177984_a().func_177972_a((Direction)direction));
            boolean value = diagonalInputChute.func_177230_c() instanceof ChuteBlock && diagonalInputChute.func_177229_b((Property)FACING) == direction;
            connections.put(direction, value);
            if (!value) continue;
            ++amtConnections;
        }
        boolean bl2 = noConnections = amtConnections == 0;
        if (vertical) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(noConnections ? (state.func_177229_b(SHAPE) == Shape.WINDOW ? Shape.WINDOW : Shape.NORMAL) : Shape.INTERSECTION)));
        }
        if (noConnections) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.NORTH)).booleanValue() && ((Boolean)connections.get(Direction.SOUTH)).booleanValue()) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.EAST)).booleanValue() && ((Boolean)connections.get(Direction.WEST)).booleanValue()) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (amtConnections == 1 && ((Boolean)connections.get(facing)).booleanValue() && ChuteBlock.getChuteFacing(above) != Direction.DOWN && (!(above.func_177230_c() instanceof FunnelBlock) || FunnelBlock.getFunnelFacing(above) != Direction.DOWN)) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    public static enum Shape implements IStringSerializable
    {
        INTERSECTION,
        WINDOW,
        NORMAL;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

