/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileType;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.registries.IRegistryDelegate;

public class BuiltinPotatoProjectileTypes {
    private static final GameProfile ZOMBIE_CONVERTER_NAME = new GameProfile(UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"), "Converter");
    private static final WorldAttached<FakePlayer> ZOMBIE_CONVERTERS = new WorldAttached(w -> new FakePlayer((ServerWorld)w, ZOMBIE_CONVERTER_NAME));
    public static final PotatoCannonProjectileType FALLBACK = BuiltinPotatoProjectileTypes.create("fallback").damage(0).register();
    public static final PotatoCannonProjectileType POTATO = BuiltinPotatoProjectileTypes.create("potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(1.5f).renderTumbling().onBlockHit(BuiltinPotatoProjectileTypes.plantCrop((IRegistryDelegate<? extends Block>)Blocks.field_150469_bN.delegate)).registerAndAssign(new IItemProvider[]{Items.field_151174_bG});
    public static final PotatoCannonProjectileType BAKED_POTATO = BuiltinPotatoProjectileTypes.create("baked_potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(0.5f).renderTumbling().preEntityHit(BuiltinPotatoProjectileTypes.setFire(3)).registerAndAssign(new IItemProvider[]{Items.field_151168_bH});
    public static final PotatoCannonProjectileType CARROT = BuiltinPotatoProjectileTypes.create("carrot").damage(4).reloadTicks(12).velocity(1.45f).knockback(0.3f).renderTowardMotion(140, 1.0f).soundPitch(1.5f).onBlockHit(BuiltinPotatoProjectileTypes.plantCrop((IRegistryDelegate<? extends Block>)Blocks.field_150459_bM.delegate)).registerAndAssign(new IItemProvider[]{Items.field_151172_bF});
    public static final PotatoCannonProjectileType GOLDEN_CARROT = BuiltinPotatoProjectileTypes.create("golden_carrot").damage(12).reloadTicks(15).velocity(1.45f).knockback(0.5f).renderTowardMotion(140, 2.0f).soundPitch(1.5f).registerAndAssign(new IItemProvider[]{Items.field_151150_bK});
    public static final PotatoCannonProjectileType SWEET_BERRIES = BuiltinPotatoProjectileTypes.create("sweet_berry").damage(3).reloadTicks(10).knockback(0.1f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign(new IItemProvider[]{Items.field_222112_pR});
    public static final PotatoCannonProjectileType CHOCOLATE_BERRIES = BuiltinPotatoProjectileTypes.create("chocolate_berry").damage(4).reloadTicks(10).knockback(0.2f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign((IItemProvider)AllItems.CHOCOLATE_BERRIES.get());
    public static final PotatoCannonProjectileType POISON_POTATO = BuiltinPotatoProjectileTypes.create("poison_potato").damage(5).reloadTicks(15).knockback(0.05f).velocity(1.25f).renderTumbling().onEntityHit(BuiltinPotatoProjectileTypes.potion(Effects.field_76436_u, 1, 160, true)).registerAndAssign(new IItemProvider[]{Items.field_151170_bI});
    public static final PotatoCannonProjectileType CHORUS_FRUIT = BuiltinPotatoProjectileTypes.create("chorus_fruit").damage(3).reloadTicks(15).velocity(1.2f).knockback(0.05f).renderTumbling().onEntityHit(BuiltinPotatoProjectileTypes.chorusTeleport(20.0)).registerAndAssign(new IItemProvider[]{Items.field_185161_cS});
    public static final PotatoCannonProjectileType APPLE = BuiltinPotatoProjectileTypes.create("apple").damage(5).reloadTicks(10).velocity(1.45f).knockback(0.5f).renderTumbling().soundPitch(1.1f).registerAndAssign(new IItemProvider[]{Items.field_151034_e});
    public static final PotatoCannonProjectileType HONEYED_APPLE = BuiltinPotatoProjectileTypes.create("honeyed_apple").damage(6).reloadTicks(15).velocity(1.35f).knockback(0.1f).renderTumbling().soundPitch(1.1f).onEntityHit(BuiltinPotatoProjectileTypes.potion(Effects.field_76421_d, 2, 160, true)).registerAndAssign((IItemProvider)AllItems.HONEYED_APPLE.get());
    public static final PotatoCannonProjectileType GOLDEN_APPLE = BuiltinPotatoProjectileTypes.create("golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit(ray -> {
        Entity entity = ray.func_216348_a();
        World world = entity.field_70170_p;
        if (!(entity instanceof ZombieVillagerEntity) || !((ZombieVillagerEntity)entity).func_70644_a(Effects.field_76437_t)) {
            return BuiltinPotatoProjectileTypes.foodEffects(Foods.field_221445_u, false).test((EntityRayTraceResult)ray);
        }
        if (world.field_72995_K) {
            return false;
        }
        FakePlayer dummy = ZOMBIE_CONVERTERS.get((IWorld)world);
        dummy.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151153_ao, 1));
        ((ZombieVillagerEntity)entity).func_230254_b_((PlayerEntity)dummy, Hand.MAIN_HAND);
        return true;
    }).registerAndAssign(new IItemProvider[]{Items.field_151153_ao});
    public static final PotatoCannonProjectileType ENCHANTED_GOLDEN_APPLE = BuiltinPotatoProjectileTypes.create("enchanted_golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit(BuiltinPotatoProjectileTypes.foodEffects(Foods.field_221444_t, false)).registerAndAssign(new IItemProvider[]{Items.field_196100_at});
    public static final PotatoCannonProjectileType BEETROOT = BuiltinPotatoProjectileTypes.create("beetroot").damage(2).reloadTicks(5).velocity(1.6f).knockback(0.1f).renderTowardMotion(140, 2.0f).soundPitch(1.6f).registerAndAssign(new IItemProvider[]{Items.field_185164_cV});
    public static final PotatoCannonProjectileType MELON_SLICE = BuiltinPotatoProjectileTypes.create("melon_slice").damage(3).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).registerAndAssign(new IItemProvider[]{Items.field_151127_ba});
    public static final PotatoCannonProjectileType GLISTENING_MELON = BuiltinPotatoProjectileTypes.create("glistening_melon").damage(5).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).onEntityHit(BuiltinPotatoProjectileTypes.potion(Effects.field_188423_x, 1, 100, true)).registerAndAssign(new IItemProvider[]{Items.field_151060_bw});
    public static final PotatoCannonProjectileType MELON_BLOCK = BuiltinPotatoProjectileTypes.create("melon_block").damage(8).reloadTicks(20).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(BuiltinPotatoProjectileTypes.placeBlockOnGround((IRegistryDelegate<? extends Block>)Blocks.field_150440_ba.delegate)).registerAndAssign(new IItemProvider[]{Blocks.field_150440_ba});
    public static final PotatoCannonProjectileType PUMPKIN_BLOCK = BuiltinPotatoProjectileTypes.create("pumpkin_block").damage(6).reloadTicks(15).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(BuiltinPotatoProjectileTypes.placeBlockOnGround((IRegistryDelegate<? extends Block>)Blocks.field_150423_aK.delegate)).registerAndAssign(new IItemProvider[]{Blocks.field_150423_aK});
    public static final PotatoCannonProjectileType PUMPKIN_PIE = BuiltinPotatoProjectileTypes.create("pumpkin_pie").damage(7).reloadTicks(15).knockback(0.05f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.1f).registerAndAssign(new IItemProvider[]{Items.field_151158_bO});
    public static final PotatoCannonProjectileType CAKE = BuiltinPotatoProjectileTypes.create("cake").damage(8).reloadTicks(15).knockback(0.1f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.0f).registerAndAssign(new IItemProvider[]{Items.field_222070_lD});
    public static final PotatoCannonProjectileType BLAZE_CAKE = BuiltinPotatoProjectileTypes.create("blaze_cake").damage(15).reloadTicks(20).knockback(0.3f).velocity(1.1f).renderTumbling().sticky().preEntityHit(BuiltinPotatoProjectileTypes.setFire(12)).soundPitch(1.0f).registerAndAssign((IItemProvider)AllItems.BLAZE_CAKE.get());

    private static PotatoCannonProjectileType.Builder create(String name) {
        return new PotatoCannonProjectileType.Builder(Create.asResource(name));
    }

    private static Predicate<EntityRayTraceResult> setFire(int seconds) {
        return ray -> {
            ray.func_216348_a().func_70015_d(seconds);
            return false;
        };
    }

    private static Predicate<EntityRayTraceResult> potion(Effect effect, int level, int ticks, boolean recoverable) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            if (entity.field_70170_p.field_72995_K) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                BuiltinPotatoProjectileTypes.applyEffect((LivingEntity)entity, new EffectInstance(effect, ticks, level - 1));
            }
            return !recoverable;
        };
    }

    private static Predicate<EntityRayTraceResult> foodEffects(Food food, boolean recoverable) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            if (entity.field_70170_p.field_72995_K) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                for (Pair effect : food.func_221464_f()) {
                    if (!(Create.RANDOM.nextFloat() < ((Float)effect.getSecond()).floatValue())) continue;
                    BuiltinPotatoProjectileTypes.applyEffect((LivingEntity)entity, new EffectInstance((EffectInstance)effect.getFirst()));
                }
            }
            return !recoverable;
        };
    }

    public static void applyEffect(LivingEntity entity, EffectInstance effect) {
        if (effect.func_188419_a().func_76403_b()) {
            effect.func_188419_a().func_180793_a(null, null, entity, effect.func_76459_b(), 1.0);
        } else {
            entity.func_195064_c(effect);
        }
    }

    private static BiPredicate<IWorld, BlockRayTraceResult> plantCrop(IRegistryDelegate<? extends Block> cropBlock) {
        return (world, ray) -> {
            if (world.func_201670_d()) {
                return true;
            }
            BlockPos hitPos = ray.func_216350_a();
            if (!world.isAreaLoaded(hitPos, 1)) {
                return true;
            }
            Direction face = ray.func_216354_b();
            BlockPos placePos = hitPos.func_177972_a(face);
            if (!world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                return false;
            }
            if (!(cropBlock.get() instanceof IPlantable)) {
                return false;
            }
            BlockState blockState = world.func_180495_p(hitPos);
            if (!blockState.canSustainPlant((IBlockReader)world, hitPos, face, (IPlantable)cropBlock.get())) {
                return false;
            }
            world.func_180501_a(placePos, ((Block)cropBlock.get()).func_176223_P(), 3);
            return true;
        };
    }

    private static BiPredicate<IWorld, BlockRayTraceResult> placeBlockOnGround(IRegistryDelegate<? extends Block> block) {
        return (world, ray) -> {
            if (world.func_201670_d()) {
                return true;
            }
            BlockPos hitPos = ray.func_216350_a();
            if (!world.isAreaLoaded(hitPos, 1)) {
                return true;
            }
            Direction face = ray.func_216354_b();
            BlockPos placePos = hitPos.func_177972_a(face);
            if (!world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                return false;
            }
            if (face == Direction.UP) {
                world.func_180501_a(placePos, ((Block)block.get()).func_176223_P(), 3);
            } else if (world instanceof World) {
                double y = ray.func_216347_e().field_72448_b - 0.5;
                if (!world.func_175623_d(placePos.func_177984_a())) {
                    y = Math.min(y, (double)placePos.func_177956_o());
                }
                if (!world.func_175623_d(placePos.func_177977_b())) {
                    y = Math.max(y, (double)placePos.func_177956_o());
                }
                FallingBlockEntity falling = new FallingBlockEntity((World)world, (double)placePos.func_177958_n() + 0.5, y, (double)placePos.func_177952_p() + 0.5, ((Block)block.get()).func_176223_P());
                falling.field_145812_b = 1;
                world.func_217376_c((Entity)falling);
            }
            return true;
        };
    }

    private static Predicate<EntityRayTraceResult> chorusTeleport(double teleportDiameter) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            World world = entity.func_130014_f_();
            if (world.field_72995_K) {
                return true;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            double entityX = livingEntity.func_226277_ct_();
            double entityY = livingEntity.func_226278_cu_();
            double entityZ = livingEntity.func_226281_cx_();
            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportZ;
                double teleportY;
                double teleportX = entityX + (livingEntity.func_70681_au().nextDouble() - 0.5) * teleportDiameter;
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)livingEntity, (double)teleportX, (double)(teleportY = MathHelper.func_151237_a((double)(entityY + (double)(livingEntity.func_70681_au().nextInt((int)teleportDiameter) - (int)(teleportDiameter / 2.0))), (double)0.0, (double)(world.func_234938_ad_() - 1))), (double)(teleportZ = entityZ + (livingEntity.func_70681_au().nextDouble() - 0.5) * teleportDiameter));
                if (event.isCanceled()) {
                    return false;
                }
                if (!livingEntity.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                if (livingEntity.func_184218_aH()) {
                    livingEntity.func_184210_p();
                }
                SoundEvent soundevent = livingEntity instanceof FoxEntity ? SoundEvents.field_232710_ez_ : SoundEvents.field_187544_ad;
                world.func_184148_a(null, entityX, entityY, entityZ, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                livingEntity.func_184185_a(soundevent, 1.0f, 1.0f);
                livingEntity.func_213317_d(Vector3d.field_186680_a);
                return true;
            }
            return false;
        };
    }

    public static void register() {
    }
}

