/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.tools.BlueprintEntity;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlueprintOverlayRenderer {
    static boolean active;
    static boolean empty;
    static boolean lastSneakState;
    static BlueprintEntity.BlueprintSection lastTargetedSection;
    static Map<ItemStack, ItemStack[]> cachedRenderedFilters;
    static List<Pair<ItemStack, Boolean>> ingredients;
    static ItemStack result;
    static boolean resultCraftable;

    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult mouseOver = mc.field_71476_x;
        BlueprintEntity.BlueprintSection last = lastTargetedSection;
        boolean sneak = mc.field_71439_g.func_225608_bj_();
        lastTargetedSection = null;
        active = false;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return;
        }
        EntityRayTraceResult entityRay = (EntityRayTraceResult)mouseOver;
        if (!(entityRay.func_216348_a() instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entityRay.func_216348_a();
        BlueprintEntity.BlueprintSection sectionAt = blueprintEntity.getSectionAt(entityRay.func_216347_e().func_178788_d(blueprintEntity.func_213303_ch()));
        lastTargetedSection = last;
        active = true;
        if (sectionAt != lastTargetedSection || AnimationTickHolder.getTicks() % 10 == 0 || lastSneakState != sneak) {
            BlueprintOverlayRenderer.rebuild(sectionAt, sneak);
        }
        lastTargetedSection = sectionAt;
        lastSneakState = sneak;
    }

    public static void rebuild(BlueprintEntity.BlueprintSection sectionAt, boolean sneak) {
        int i;
        cachedRenderedFilters.clear();
        ItemStackHandler items = sectionAt.getItems();
        boolean empty = true;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (items.getStackInSlot(i2).func_190926_b()) continue;
            empty = false;
            break;
        }
        BlueprintOverlayRenderer.empty = empty;
        result = ItemStack.field_190927_a;
        if (empty) {
            return;
        }
        boolean firstPass = true;
        boolean success = true;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStackHandler playerInv = new ItemStackHandler(mc.field_71439_g.field_71071_by.func_70302_i_());
        for (int i3 = 0; i3 < playerInv.getSlots(); ++i3) {
            playerInv.setStackInSlot(i3, mc.field_71439_g.field_71071_by.func_70301_a(i3).func_77946_l());
        }
        int amountCrafted = 0;
        Optional recipe = Optional.empty();
        HashMap<Integer, ItemStack> craftingGrid = new HashMap<Integer, ItemStack>();
        ingredients.clear();
        ItemStackHandler missingItems = new ItemStackHandler(64);
        ItemStackHandler availableItems = new ItemStackHandler(64);
        ArrayList<ItemStack> newlyAdded = new ArrayList<ItemStack>();
        ArrayList<ItemStack> newlyMissing = new ArrayList<ItemStack>();
        boolean invalid = false;
        do {
            craftingGrid.clear();
            newlyAdded.clear();
            newlyMissing.clear();
            block3: for (i = 0; i < 9; ++i) {
                ItemStack requestedItem = items.getStackInSlot(i);
                if (requestedItem.func_190926_b()) {
                    craftingGrid.put(i, ItemStack.field_190927_a);
                    continue;
                }
                for (int slot = 0; slot < playerInv.getSlots(); ++slot) {
                    if (!FilterItem.test((World)mc.field_71441_e, playerInv.getStackInSlot(slot), requestedItem)) continue;
                    ItemStack currentItem = playerInv.extractItem(slot, 1, false);
                    craftingGrid.put(i, currentItem);
                    newlyAdded.add(currentItem);
                    continue block3;
                }
                success = false;
                newlyMissing.add(requestedItem);
            }
            if (success) {
                ItemStack resultFromRecipe;
                BlueprintEntity.BlueprintCraftingInventory craftingInventory = new BlueprintEntity.BlueprintCraftingInventory(craftingGrid);
                if (!recipe.isPresent()) {
                    recipe = mc.field_71441_e.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, (World)mc.field_71441_e);
                }
                if ((resultFromRecipe = recipe.filter(r -> r.func_77569_a((IInventory)craftingInventory, (World)mc.field_71441_e)).map(r -> r.func_77572_b((IInventory)craftingInventory)).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                    if (!recipe.isPresent()) {
                        invalid = true;
                    }
                    success = false;
                } else if (resultFromRecipe.func_190916_E() + amountCrafted > 64) {
                    success = false;
                } else {
                    amountCrafted += resultFromRecipe.func_190916_E();
                    if (result.func_190926_b()) {
                        result = resultFromRecipe.func_77946_l();
                    } else {
                        result.func_190917_f(resultFromRecipe.func_190916_E());
                    }
                    resultCraftable = true;
                    firstPass = false;
                }
            }
            if (success || firstPass) {
                newlyAdded.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)availableItems, (ItemStack)s, (boolean)false));
                newlyMissing.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)missingItems, (ItemStack)s, (boolean)false));
            }
            if (success) continue;
            if (!firstPass) break;
            result = invalid ? ItemStack.field_190927_a : items.getStackInSlot(9);
            resultCraftable = false;
            break;
        } while (sneak && success);
        for (i = 0; i < 9; ++i) {
            ItemStack available = availableItems.getStackInSlot(i);
            if (available.func_190926_b()) continue;
            ingredients.add(Pair.of(available, true));
        }
        for (i = 0; i < 9; ++i) {
            ItemStack missing = missingItems.getStackInSlot(i);
            if (missing.func_190926_b()) continue;
            ingredients.add(Pair.of(missing, false));
        }
    }

    public static void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, float partialTicks) {
        if (!active || empty) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int w = 30 + 21 * ingredients.size() + 21;
        int x = (mc.func_228018_at_().func_198107_o() - w) / 2;
        int y = (int)((float)mc.func_228018_at_().func_198087_p() / 3.0f * 2.0f);
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            (pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).draw(ms, x, y);
            ItemStack itemStack = pair.getFirst();
            String count = pair.getSecond() != false ? null : TextFormatting.GOLD.toString() + itemStack.func_190916_E();
            BlueprintOverlayRenderer.drawItemStack(ms, mc, x, y, itemStack, count);
            x += 21;
        }
        RenderSystem.enableBlend();
        AllGuiTextures.HOTSLOT_ARROW.draw(ms, x += 5, y + 4);
        x += 25;
        if (result.func_190926_b()) {
            AllGuiTextures.HOTSLOT.draw(ms, x, y);
            ((RenderElement)GuiGameElement.of((IItemProvider)Items.field_221803_eL).at(x + 3, y + 3)).render(ms);
        } else {
            (resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT).draw(ms, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
            BlueprintOverlayRenderer.drawItemStack(ms, mc, x, y, result, null);
        }
    }

    public static void drawItemStack(MatrixStack ms, Minecraft mc, int x, int y, ItemStack itemStack, String count) {
        if (itemStack.func_77973_b() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((IWorld)mc.field_71441_e) / 10;
            ItemStack[] itemsMatchingFilter = BlueprintOverlayRenderer.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        ((RenderElement)GuiGameElement.of(itemStack).at(x + 3, y + 3)).render(ms);
        mc.func_175599_af().func_180453_a(mc.field_71466_p, itemStack, x + 3, y + 3, count);
    }

    private static ItemStack[] getItemsMatchingFilter(ItemStack filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            CompoundNBT tag = itemStack.func_196082_o();
            if (AllItems.FILTER.isIn((ItemStack)itemStack) && !tag.func_74767_n("Blacklist")) {
                ItemStackHandler filterItems = FilterItem.getFilterItems(itemStack);
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                    ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                    if (stackInSlot.func_190926_b()) continue;
                    list.add(stackInSlot);
                }
                return list.toArray(new ItemStack[list.size()]);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn((ItemStack)itemStack)) {
                ItemAttribute fromNBT;
                AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[tag.func_74762_e("WhitelistMode")];
                ListNBT attributes = tag.func_150295_c("MatchedAttributes", 10);
                if (whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ && attributes.size() == 1 && (fromNBT = ItemAttribute.fromNBT((CompoundNBT)attributes.get(0))) instanceof ItemAttribute.InTag) {
                    ItemAttribute.InTag inTag = (ItemAttribute.InTag)fromNBT;
                    ITag itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(inTag.tagName);
                    if (itag != null) {
                        return Ingredient.func_199805_a((ITag)itag).func_193365_a();
                    }
                }
            }
            return new ItemStack[0];
        });
    }

    static {
        cachedRenderedFilters = new IdentityHashMap<ItemStack, ItemStack[]>();
        ingredients = new ArrayList<Pair<ItemStack, Boolean>>();
        result = ItemStack.field_190927_a;
        resultCraftable = false;
    }
}

