/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.curiosities.bell.AbstractBellTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.block.BellBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class BellRenderer<TE extends AbstractBellTileEntity>
extends SafeTileEntityRenderer<TE> {
    public BellRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(TE te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState state = te.func_195044_w();
        Direction facing = (Direction)state.func_177229_b((Property)BellBlock.field_220133_a);
        BellAttachment attachment = (BellAttachment)state.func_177229_b((Property)BellBlock.field_220134_b);
        SuperByteBuffer bell = PartialBufferer.get(((AbstractBellTileEntity)te).getBellModel(), state);
        if (((AbstractBellTileEntity)te).isRinging) {
            bell.rotateCentered(((AbstractBellTileEntity)te).ringDirection.func_176735_f(), BellRenderer.getSwingAngle((float)((AbstractBellTileEntity)te).ringingTicks + partialTicks));
        }
        float rY = AngleHelper.horizontalAngle(facing);
        if (attachment == BellAttachment.SINGLE_WALL || attachment == BellAttachment.DOUBLE_WALL) {
            rY += 90.0f;
        }
        bell.rotateCentered(Direction.UP, AngleHelper.rad(rY));
        bell.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228643_e_()));
    }

    public static float getSwingAngle(float time) {
        float t = time / 1.5f;
        return 1.2f * MathHelper.func_76126_a((float)(t / (float)Math.PI)) / (2.5f + t / 3.0f);
    }
}

