/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeBlock;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class GaugeRenderer
extends KineticTileEntityRenderer {
    protected GaugeBlock.Type type;

    public static GaugeRenderer speed(TileEntityRendererDispatcher dispatcher) {
        return new GaugeRenderer(dispatcher, GaugeBlock.Type.SPEED);
    }

    public static GaugeRenderer stress(TileEntityRendererDispatcher dispatcher) {
        return new GaugeRenderer(dispatcher, GaugeBlock.Type.STRESS);
    }

    protected GaugeRenderer(TileEntityRendererDispatcher dispatcher, GaugeBlock.Type type) {
        super(dispatcher);
        this.type = type;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        BlockState gaugeState = te.func_195044_w();
        GaugeTileEntity gaugeTE = (GaugeTileEntity)te;
        PartialModel partialModel = this.type == GaugeBlock.Type.SPEED ? AllBlockPartials.GAUGE_HEAD_SPEED : AllBlockPartials.GAUGE_HEAD_STRESS;
        SuperByteBuffer headBuffer = PartialBufferer.get(partialModel, gaugeState);
        SuperByteBuffer dialBuffer = PartialBufferer.get(AllBlockPartials.GAUGE_DIAL, gaugeState);
        float dialPivot = 0.359375f;
        float progress = MathHelper.func_219799_g((float)partialTicks, (float)gaugeTE.prevDialState, (float)gaugeTE.dialState);
        for (Direction facing : Iterate.directions) {
            if (!((GaugeBlock)gaugeState.func_177230_c()).shouldRenderHeadOnFace(te.func_145831_w(), te.func_174877_v(), gaugeState, facing)) continue;
            IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
            this.rotateBufferTowards(dialBuffer, facing).translate(0.0f, dialPivot, dialPivot).rotate(Direction.EAST, (float)(1.5707963267948966 * (double)(-progress))).translate(0.0f, -dialPivot, -dialPivot).light(light).renderInto(ms, vb);
            this.rotateBufferTowards(headBuffer, facing).light(light).renderInto(ms, vb);
        }
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return GaugeRenderer.shaft(GaugeRenderer.getRotationAxisOf(te));
    }

    protected SuperByteBuffer rotateBufferTowards(SuperByteBuffer buffer, Direction target) {
        return buffer.rotateCentered(Direction.UP, (float)((double)((-target.func_185119_l() - 90.0f) / 180.0f) * Math.PI));
    }
}

