/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltCrusherInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltFunnelInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BeltInventory {
    final BeltTileEntity belt;
    private final List<TransportedItemStack> items;
    final List<TransportedItemStack> toInsert;
    final List<TransportedItemStack> toRemove;
    boolean beltMovementPositive;
    final float SEGMENT_WINDOW = 0.75f;

    public BeltInventory(BeltTileEntity te) {
        this.belt = te;
        this.items = new LinkedList<TransportedItemStack>();
        this.toInsert = new LinkedList<TransportedItemStack>();
        this.toRemove = new LinkedList<TransportedItemStack>();
    }

    public void tick() {
        if (!this.toInsert.isEmpty() || !this.toRemove.isEmpty()) {
            this.toInsert.forEach(this::insert);
            this.toInsert.clear();
            this.items.removeAll(this.toRemove);
            this.toRemove.clear();
            this.belt.func_70296_d();
            this.belt.sendData();
        }
        if (this.belt.getSpeed() == 0.0f) {
            return;
        }
        if (this.beltMovementPositive != this.belt.getDirectionAwareBeltMovementSpeed() > 0.0f) {
            this.beltMovementPositive = !this.beltMovementPositive;
            Collections.reverse(this.items);
            this.belt.func_70296_d();
            this.belt.sendData();
        }
        TransportedItemStack stackInFront = null;
        TransportedItemStack currentItem = null;
        Iterator<TransportedItemStack> iterator = this.items.iterator();
        float beltSpeed = this.belt.getDirectionAwareBeltMovementSpeed();
        Direction movementFacing = this.belt.getMovementFacing();
        boolean horizontal = this.belt.func_195044_w().func_177229_b(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
        float spacing = 1.0f;
        World world = this.belt.func_145831_w();
        boolean onClient = world.field_72995_K && !this.belt.isVirtual();
        Ending ending = Ending.UNRESOLVED;
        while (iterator.hasNext()) {
            float diffToEnd;
            stackInFront = currentItem;
            currentItem = iterator.next();
            currentItem.prevBeltPosition = currentItem.beltPosition;
            currentItem.prevSideOffset = currentItem.sideOffset;
            if (currentItem.stack.func_190926_b()) {
                iterator.remove();
                currentItem = null;
                continue;
            }
            float movement = beltSpeed;
            if (onClient) {
                movement *= ServerSpeedProvider.get();
            }
            if (world.field_72995_K && currentItem.locked) continue;
            if (currentItem.lockedExternally) {
                currentItem.lockedExternally = false;
                continue;
            }
            boolean noMovement = false;
            float currentPos = currentItem.beltPosition;
            if (stackInFront != null) {
                float diff = stackInFront.beltPosition - currentPos;
                if (Math.abs(diff) <= spacing) {
                    noMovement = true;
                }
                movement = this.beltMovementPositive ? Math.min(movement, diff - spacing) : Math.max(movement, diff + spacing);
            }
            float f = diffToEnd = this.beltMovementPositive ? (float)this.belt.beltLength - currentPos : -currentPos;
            if (Math.abs(diffToEnd) < Math.abs(movement) + 1.0f) {
                if (ending == Ending.UNRESOLVED) {
                    ending = this.resolveEnding();
                }
                diffToEnd += this.beltMovementPositive ? -ending.margin : ending.margin;
            }
            float limitedMovement = this.beltMovementPositive ? Math.min(movement, diffToEnd) : Math.max(movement, diffToEnd);
            float nextOffset = currentItem.beltPosition + limitedMovement;
            if (!onClient && horizontal) {
                ItemStack item = currentItem.stack;
                if (this.handleBeltProcessingAndCheckIfRemoved(currentItem, nextOffset, noMovement)) {
                    iterator.remove();
                    this.belt.sendData();
                    continue;
                }
                if (item != currentItem.stack) {
                    this.belt.sendData();
                }
                if (currentItem.locked) continue;
            }
            if (noMovement || BeltTunnelInteractionHandler.flapTunnelsAndCheckIfStuck(this, currentItem, nextOffset) || BeltFunnelInteractionHandler.checkForFunnels(this, currentItem, nextOffset) || BeltCrusherInteractionHandler.checkForCrushers(this, currentItem, nextOffset)) continue;
            currentItem.beltPosition += limitedMovement;
            currentItem.sideOffset += (currentItem.getTargetSideOffset() - currentItem.sideOffset) * Math.abs(limitedMovement) * 2.0f;
            currentPos = currentItem.beltPosition;
            if (limitedMovement == movement || onClient) continue;
            int lastOffset = this.beltMovementPositive ? this.belt.beltLength - 1 : 0;
            BlockPos nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1);
            if (ending == Ending.FUNNEL) continue;
            if (ending == Ending.INSERT) {
                ItemStack remainder;
                DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((IBlockReader)world, nextPosition, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null || !inputBehaviour.canInsertFromSide(movementFacing) || (remainder = inputBehaviour.handleInsertion(currentItem, movementFacing, false)).equals(currentItem.stack, false)) continue;
                currentItem.stack = remainder;
                if (remainder.func_190926_b()) {
                    iterator.remove();
                }
                BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
                this.belt.sendData();
                continue;
            }
            if (ending == Ending.BLOCKED || ending != Ending.EJECT) continue;
            this.eject(currentItem);
            iterator.remove();
            BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
            this.belt.sendData();
        }
    }

    protected boolean handleBeltProcessingAndCheckIfRemoved(TransportedItemStack currentItem, float nextOffset, boolean noMovement) {
        int currentSegment = (int)currentItem.beltPosition;
        if (currentItem.locked) {
            BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(currentSegment);
            TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(currentSegment);
            if (stackHandlerBehaviour == null) {
                return false;
            }
            if (processingBehaviour == null) {
                currentItem.locked = false;
                this.belt.sendData();
                return false;
            }
            BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleHeldItem(currentItem, stackHandlerBehaviour);
            if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                return true;
            }
            if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                return false;
            }
            currentItem.locked = false;
            this.belt.sendData();
            return false;
        }
        if (noMovement) {
            return false;
        }
        if (currentItem.beltPosition > 0.5f || this.beltMovementPositive) {
            int firstUpcomingSegment = (int)(currentItem.beltPosition + (this.beltMovementPositive ? 0.5f : -0.5f));
            int step = this.beltMovementPositive ? 1 : -1;
            int segment = firstUpcomingSegment;
            while (this.beltMovementPositive ? (float)segment + 0.5f <= nextOffset : (float)segment + 0.5f >= nextOffset) {
                BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(segment);
                TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(segment);
                if (processingBehaviour != null && stackHandlerBehaviour != null && !BeltProcessingBehaviour.isBlocked((IBlockReader)this.belt.func_145831_w(), BeltHelper.getPositionForOffset(this.belt, segment))) {
                    BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleReceivedItem(currentItem, stackHandlerBehaviour);
                    if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                        return true;
                    }
                    if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                        currentItem.beltPosition = (float)segment + 0.5f + (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                        currentItem.locked = true;
                        this.belt.sendData();
                        return false;
                    }
                }
                segment += step;
            }
        }
        return false;
    }

    protected BeltProcessingBehaviour getBeltProcessingAtSegment(int segment) {
        return TileEntityBehaviour.get((IBlockReader)this.belt.func_145831_w(), BeltHelper.getPositionForOffset(this.belt, segment).func_177981_b(2), BeltProcessingBehaviour.TYPE);
    }

    protected TransportedItemStackHandlerBehaviour getTransportedItemStackHandlerAtSegment(int segment) {
        return TileEntityBehaviour.get((IBlockReader)this.belt.func_145831_w(), BeltHelper.getPositionForOffset(this.belt, segment), TransportedItemStackHandlerBehaviour.TYPE);
    }

    private Ending resolveEnding() {
        BlockPos nextPosition;
        World world = this.belt.func_145831_w();
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((IBlockReader)world, nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour != null) {
            return Ending.INSERT;
        }
        if (BlockHelper.hasBlockSolidSide(world.func_180495_p(nextPosition), (IBlockReader)world, nextPosition, this.belt.getMovementFacing().func_176734_d())) {
            return Ending.BLOCKED;
        }
        return Ending.EJECT;
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertAtFromSide(segment, Direction.UP);
    }

    public boolean canInsertAtFromSide(int segment, Direction side) {
        float segmentPos = segment;
        if (this.belt.getMovementFacing() == side.func_176734_d()) {
            return false;
        }
        if (this.belt.getMovementFacing() != side) {
            segmentPos += 0.5f;
        } else if (!this.beltMovementPositive) {
            segmentPos += 1.0f;
        }
        for (TransportedItemStack stack : this.items) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        for (TransportedItemStack stack : this.toInsert) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlocking(int segment, Direction side, float segmentPos, TransportedItemStack stack) {
        float currentPos = stack.beltPosition;
        return stack.insertedAt == segment && stack.insertedFrom == side && (this.beltMovementPositive ? currentPos <= segmentPos + 1.0f : currentPos >= segmentPos - 1.0f);
    }

    public void addItem(TransportedItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(TransportedItemStack newStack) {
        if (this.items.isEmpty()) {
            this.items.add(newStack);
        } else {
            int index = 0;
            for (TransportedItemStack stack : this.items) {
                if (stack.compareTo(newStack) > 0 == this.beltMovementPositive) break;
                ++index;
            }
            this.items.add(index, newStack);
        }
    }

    public TransportedItemStack getStackAtOffset(int offset) {
        float min = offset;
        float max = offset + 1;
        for (TransportedItemStack stack : this.items) {
            if (stack.beltPosition > max || !(stack.beltPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(CompoundNBT nbt) {
        this.items.clear();
        nbt.func_150295_c("Items", 10).forEach(inbt -> this.items.add(TransportedItemStack.read((CompoundNBT)inbt)));
        this.beltMovementPositive = nbt.func_74767_n("PositiveOrder");
    }

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT itemsNBT = new ListNBT();
        this.items.forEach(stack -> itemsNBT.add((Object)stack.serializeNBT()));
        nbt.func_218657_a("Items", (INBT)itemsNBT);
        nbt.func_74757_a("PositiveOrder", this.beltMovementPositive);
        return nbt;
    }

    public void eject(TransportedItemStack stack) {
        ItemStack ejected = stack.stack;
        Vector3d outPos = BeltHelper.getVectorForOffset(this.belt, stack.beltPosition);
        float movementSpeed = Math.max(Math.abs(this.belt.getBeltMovementSpeed()), 0.125f);
        Vector3d outMotion = Vector3d.func_237491_b_((Vector3i)this.belt.getBeltChainDirection()).func_186678_a((double)movementSpeed).func_72441_c(0.0, 0.125, 0.0);
        outPos = outPos.func_178787_e(outMotion.func_72432_b().func_186678_a(0.001));
        ItemEntity entity = new ItemEntity(this.belt.func_145831_w(), outPos.field_72450_a, outPos.field_72448_b + 0.375, outPos.field_72449_c, ejected);
        entity.func_213317_d(outMotion);
        entity.func_174869_p();
        entity.field_70133_I = true;
        this.belt.func_145831_w().func_217376_c((Entity)entity);
    }

    public void ejectAll() {
        this.items.forEach(this::eject);
        this.items.clear();
    }

    public void applyToEachWithin(float position, float maxDistanceToPosition, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        boolean dirty = false;
        for (TransportedItemStack transported : this.items) {
            TransportedItemStackHandlerBehaviour.TransportedResult result;
            ItemStack stackBefore = transported.stack.func_77946_l();
            if (Math.abs(position - transported.beltPosition) >= maxDistanceToPosition || (result = processFunction.apply(transported)) == null || result.didntChangeFrom(stackBefore)) continue;
            dirty = true;
            if (result.hasHeldOutput()) {
                TransportedItemStack held = result.getHeldOutput();
                held.beltPosition = (float)((int)position) + 0.5f - (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                this.toInsert.add(held);
            }
            this.toInsert.addAll(result.getOutputs());
            this.toRemove.add(transported);
        }
        if (dirty) {
            this.belt.func_70296_d();
            this.belt.sendData();
        }
    }

    public List<TransportedItemStack> getTransportedItems() {
        return this.items;
    }

    private static enum Ending {
        UNRESOLVED(0.0f),
        EJECT(0.0f),
        INSERT(0.25f),
        FUNNEL(0.5f),
        BLOCKED(0.45f);

        private float margin;

        private Ending(float f) {
            this.margin = f;
        }
    }
}

