/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.itemAssembly;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SequencedAssemblyRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<SequencedAssemblyRecipe> {
    protected void writeToJson(JsonObject json, SequencedAssemblyRecipe recipe) {
        JsonArray nestedRecipes = new JsonArray();
        JsonArray results = new JsonArray();
        json.add("ingredient", recipe.getIngredient().func_200304_c());
        recipe.getSequence().forEach(i -> nestedRecipes.add((JsonElement)i.toJson()));
        recipe.resultPool.forEach(p -> results.add(p.serialize()));
        json.add("transitionalItem", recipe.transitionalItem.serialize());
        json.add("sequence", (JsonElement)nestedRecipes);
        json.add("results", (JsonElement)results);
        json.addProperty("loops", (Number)recipe.loops);
    }

    protected SequencedAssemblyRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        SequencedAssemblyRecipe recipe = new SequencedAssemblyRecipe(recipeId, this);
        recipe.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
        recipe.transitionalItem = ProcessingOutput.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"transitionalItem"));
        int i = 0;
        for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"sequence")) {
            recipe.getSequence().add(SequencedRecipe.fromJson(je.getAsJsonObject(), recipe, i++));
        }
        for (JsonElement je : JSONUtils.func_151214_t((JsonObject)json, (String)"results")) {
            recipe.resultPool.add(ProcessingOutput.deserialize(je));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"loops")) {
            recipe.loops = JSONUtils.func_151203_m((JsonObject)json, (String)"loops");
        }
        return recipe;
    }

    protected void writeToBuffer(PacketBuffer buffer, SequencedAssemblyRecipe recipe) {
        recipe.getIngredient().func_199564_a(buffer);
        buffer.func_150787_b(recipe.getSequence().size());
        recipe.getSequence().forEach(sr -> sr.writeToBuffer(buffer));
        buffer.func_150787_b(recipe.resultPool.size());
        recipe.resultPool.forEach(sr -> sr.write(buffer));
        recipe.transitionalItem.write(buffer);
        buffer.writeInt(recipe.loops);
    }

    protected SequencedAssemblyRecipe readFromBuffer(ResourceLocation recipeId, PacketBuffer buffer) {
        int i;
        SequencedAssemblyRecipe recipe = new SequencedAssemblyRecipe(recipeId, this);
        recipe.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            recipe.getSequence().add(SequencedRecipe.readFromBuffer(buffer));
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            recipe.resultPool.add(ProcessingOutput.read(buffer));
        }
        recipe.transitionalItem = ProcessingOutput.read(buffer);
        recipe.loops = buffer.readInt();
        return recipe;
    }

    public final void write(JsonObject json, SequencedAssemblyRecipe recipe) {
        this.writeToJson(json, recipe);
    }

    public final SequencedAssemblyRecipe fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(PacketBuffer buffer, SequencedAssemblyRecipe recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final SequencedAssemblyRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
        return this.readFromBuffer(id, buffer);
    }
}

