/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class TransparentStraightPipeRenderer
extends SafeTileEntityRenderer<StraightPipeTileEntity> {
    public TransparentStraightPipeRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(StraightPipeTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        FluidTransportBehaviour pipe = te.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            return;
        }
        for (Direction side : Iterate.directions) {
            LerpedFloat progress;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progress = flow.progress) == null) continue;
            float value = progress.getValue(partialTicks);
            boolean inbound = flow.inbound;
            if (value == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.func_176734_d());
                    if (opposite == null) {
                        value -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = TileEntityBehaviour.get((IBlockReader)te.func_145831_w(), te.func_174877_v().func_177972_a(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        value -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.func_176734_d());
                        if (other == null || !other.inbound && !other.complete) {
                            value -= 1.0E-6f;
                        }
                    }
                }
            }
            FluidRenderer.renderFluidStream(fluidStack, side, 0.1875f, value, inbound, buffer, ms, light);
        }
    }
}

