/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.IAxisPipe;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SmartFluidPipeBlock
extends HorizontalFaceBlock
implements IAxisPipe,
IWrenchable {
    public SmartFluidPipeBlock(AbstractBlock.Properties p_i48339_1_) {
        super(p_i48339_1_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M}).func_206894_a(new Property[]{field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState stateForPlacement = super.func_196258_a(ctx);
        Direction.Axis prefferedAxis = null;
        BlockPos pos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        for (Direction side : Iterate.directions) {
            if (!this.prefersConnectionTo((IWorldReader)world, pos, side)) continue;
            if (prefferedAxis != null && prefferedAxis != side.func_176740_k()) {
                prefferedAxis = null;
                break;
            }
            prefferedAxis = side.func_176740_k();
        }
        if (prefferedAxis == Direction.Axis.Y) {
            stateForPlacement = (BlockState)((BlockState)stateForPlacement.func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)field_185512_D, (Comparable)((Direction)stateForPlacement.func_177229_b((Property)field_185512_D)).func_176734_d());
        } else if (prefferedAxis != null) {
            if (stateForPlacement.func_177229_b((Property)field_196366_M) == AttachFace.WALL) {
                stateForPlacement = (BlockState)stateForPlacement.func_206870_a((Property)field_196366_M, (Comparable)AttachFace.FLOOR);
            }
            for (Direction direction : ctx.func_196009_e()) {
                if (direction.func_176740_k() != prefferedAxis) continue;
                stateForPlacement = (BlockState)stateForPlacement.func_206870_a((Property)field_185512_D, (Comparable)direction.func_176734_d());
            }
        }
        return stateForPlacement;
    }

    protected boolean prefersConnectionTo(IWorldReader reader, BlockPos pos, Direction facing) {
        BlockPos offset = pos.func_177972_a(facing);
        BlockState blockState = reader.func_180495_p(offset);
        return FluidPipeBlock.canConnectTo((IBlockDisplayReader)reader, offset, blockState, facing);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.func_177230_c() != newState.func_177230_c();
        if (blockTypeChanged && !world.field_72995_K) {
            FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
        }
        if (state.hasTileEntity() && (blockTypeChanged || !newState.hasTileEntity())) {
            world.func_175713_t(pos);
        }
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return true;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (state != oldState) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!SmartFluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.func_176740_k() == SmartFluidPipeBlock.getPipeAxis(state);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
    }

    protected static Direction.Axis getPipeAxis(BlockState state) {
        return state.func_177229_b((Property)field_196366_M) == AttachFace.WALL ? Direction.Axis.Y : ((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.SMART_FLUID_PIPE.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        AttachFace face = (AttachFace)state.func_177229_b((Property)field_196366_M);
        VoxelShaper shape = face == AttachFace.FLOOR ? AllShapes.SMART_FLUID_PIPE_FLOOR : (face == AttachFace.CEILING ? AllShapes.SMART_FLUID_PIPE_CEILING : AllShapes.SMART_FLUID_PIPE_WALL);
        return shape.get((Direction)state.func_177229_b((Property)field_185512_D));
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return SmartFluidPipeBlock.getPipeAxis(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }
}

