/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.actors.FluidDrainingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.FluidFillingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyBlock;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyFluidHandler;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HosePulleyTileEntity
extends KineticTileEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    private SmartFluidTank internalTank = new SmartFluidTank(1500, this::onTankContentsChanged);
    private LazyOptional<IFluidHandler> capability;
    private FluidDrainingBehaviour drainer;
    private FluidFillingBehaviour filler;
    private HosePulleyFluidHandler handler = new HosePulleyFluidHandler(this.internalTank, this.filler, this.drainer, () -> this.field_174879_c.func_177979_c((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    private boolean infinite;

    public HosePulleyTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.capability = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void sendData() {
        this.infinite = this.filler.infinite || this.drainer.infinite;
        super.sendData();
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        boolean addToGoggleTooltip = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.infinite) {
            TooltipHelper.addHint(tooltip, "hint.hose_pulley", new Object[0]);
        }
        return addToGoggleTooltip;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.drainer = new FluidDrainingBehaviour(this);
        this.filler = new FluidFillingBehaviour(this);
        behaviours.add(this.drainer);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
    }

    protected void onTankContentsChanged(FluidStack contents) {
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue(Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c((int)Math.ceil(newOffset))).func_185904_a().func_76222_j()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.drainer.reset();
                this.filler.reset();
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() + (double)(this.offset.getValue() * this.offset.getValue());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c((int)Math.ceil(newOffset))).func_185904_a().func_76222_j()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue(newOffset);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(ceil)).func_185904_a().func_76222_j()) {
            this.isMoving = true;
            this.drainer.reset();
            this.filler.reset();
            return;
        }
        this.sendData();
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_218657_a("Offset", (INBT)this.offset.writeNBT());
        compound.func_218657_a("Tank", (INBT)this.internalTank.writeToNBT(new CompoundNBT()));
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.func_74757_a("Infinite", this.infinite);
        }
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.offset.readNBT(compound.func_74775_l("Offset"), clientPacket);
        this.internalTank.readFromNBT(compound.func_74775_l("Tank"));
        super.fromTag(state, compound, clientPacket);
        if (clientPacket) {
            this.infinite = compound.func_74767_n("Infinite");
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.capability.invalidate();
    }

    public float getMovementSpeed() {
        float movementSpeed = HosePulleyTileEntity.convertToLinear(this.getSpeed());
        if (this.field_145850_b.field_72995_K) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public float getInterpolatedOffset(float pt) {
        return this.offset.getValue(pt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap) && (side == null || HosePulleyBlock.hasPipeTowards((IWorldReader)this.field_145850_b, this.field_174879_c, this.func_195044_w(), side))) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean shouldRenderNormally() {
        return true;
    }
}

