/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.foundation.render.PartialBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;

public class GantryCarriageRenderer
extends KineticTileEntityRenderer {
    public GantryCarriageRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.getInstance().canUseInstancing(te.func_145831_w())) {
            return;
        }
        BlockState state = te.func_195044_w();
        Direction facing = (Direction)state.func_177229_b((Property)GantryCarriageBlock.FACING);
        Boolean alongFirst = (Boolean)state.func_177229_b((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        Direction.Axis rotationAxis = GantryCarriageRenderer.getRotationAxisOf(te);
        BlockPos visualPos = facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? te.func_174877_v() : te.func_174877_v().func_177972_a(facing.func_176734_d());
        float angleForTe = GantryCarriageRenderer.getAngleForTe(te, visualPos, rotationAxis);
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facing.func_176740_k()) continue;
            gantryAxis = axis;
        }
        if (gantryAxis == Direction.Axis.Z && facing == Direction.DOWN) {
            angleForTe *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            angleForTe *= -1.0f;
        }
        SuperByteBuffer cogs = PartialBufferer.get(AllBlockPartials.GANTRY_COGS, state);
        cogs.matrixStacker().centre().rotateY((double)AngleHelper.horizontalAngle(facing)).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0)).rotateY(alongFirst ^ facing.func_176740_k() == Direction.Axis.Z ? 90.0 : 0.0).translate(0.0, -0.5625, 0.0).multiply(Vector3f.field_229179_b_.func_229193_c_(-angleForTe)).translate(0.0, 0.5625, 0.0).unCentre();
        cogs.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((IWorld)te.func_145831_w());
        float offset = GantryCarriageRenderer.getRotationOffsetForPosition(te, pos, axis);
        return (time * te.getSpeed() * 3.0f / 20.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return GantryCarriageRenderer.shaft(GantryCarriageRenderer.getRotationAxisOf(te));
    }
}

