/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.AnchoredLighter;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkContraption
extends Contraption {
    protected Direction facing;
    public HandType handType;
    public int offset;
    private Set<BlockPos> ignoreBlocks = new HashSet<BlockPos>();

    @Override
    protected ContraptionType getType() {
        return ContraptionType.CLOCKWORK;
    }

    private void ignoreBlocks(Set<BlockPos> blocks, BlockPos anchor) {
        for (BlockPos blockPos : blocks) {
            this.ignoreBlocks.add(anchor.func_177971_a((Vector3i)blockPos));
        }
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.func_177967_a(this.facing.func_176734_d(), this.offset + 1));
    }

    public static Pair<ClockworkContraption, ClockworkContraption> assembleClockworkAt(World world, BlockPos pos, Direction direction) throws AssemblyException {
        int hourArmBlocks = 0;
        ClockworkContraption hourArm = new ClockworkContraption();
        ClockworkContraption minuteArm = null;
        hourArm.facing = direction;
        hourArm.handType = HandType.HOUR;
        if (!hourArm.assemble(world, pos)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            BlockPos offsetPos = BlockPos.field_177992_a.func_177967_a(direction, i);
            if (hourArm.getBlocks().containsKey(offsetPos)) continue;
            hourArmBlocks = i;
            break;
        }
        if (hourArmBlocks > 0) {
            minuteArm = new ClockworkContraption();
            minuteArm.facing = direction;
            minuteArm.handType = HandType.MINUTE;
            minuteArm.offset = hourArmBlocks;
            minuteArm.ignoreBlocks(hourArm.getBlocks().keySet(), hourArm.anchor);
            if (!minuteArm.assemble(world, pos)) {
                return null;
            }
            if (minuteArm.getBlocks().isEmpty()) {
                minuteArm = null;
            }
        }
        hourArm.startMoving(world);
        hourArm.expandBoundsAroundAxis(direction.func_176740_k());
        if (minuteArm != null) {
            minuteArm.startMoving(world);
            minuteArm.expandBoundsAroundAxis(direction.func_176740_k());
        }
        return Pair.of((Object)hourArm, (Object)minuteArm);
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        return this.searchMovedStructure(world, pos, this.facing);
    }

    @Override
    public boolean searchMovedStructure(World world, BlockPos pos, Direction direction) throws AssemblyException {
        return super.searchMovedStructure(world, pos.func_177967_a(direction, this.offset + 1), null);
    }

    @Override
    protected boolean moveBlock(World world, Direction direction, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        if (this.ignoreBlocks.contains(frontier.peek())) {
            frontier.poll();
            return true;
        }
        return super.moveBlock(world, direction, frontier, visited);
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("facing", this.facing.func_176745_a());
        tag.func_74768_a("offset", this.offset);
        NBTHelper.writeEnum(tag, "HandType", this.handType);
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag, boolean spawnData) {
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("facing"));
        this.handType = NBTHelper.readEnum(tag, "HandType", HandType.class);
        this.offset = tag.func_74762_e("offset");
        super.readNBT(world, tag, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        if (BlockPos.field_177992_a.equals((Object)localPos) || BlockPos.field_177992_a.equals((Object)localPos.func_177972_a(facing))) {
            return false;
        }
        return facing.func_176740_k() == this.facing.func_176740_k();
    }

    @Override
    public ContraptionLighter<?> makeLighter() {
        return new AnchoredLighter(this);
    }

    public static enum HandType {
        HOUR,
        MINUTE;

    }
}

