/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.SeatBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class SeatMovementBehaviour
extends MovementBehaviour {
    @Override
    public void startMoving(MovementContext context) {
        super.startMoving(context);
        int indexOf = context.contraption.getSeats().indexOf(context.localPos);
        context.data.func_74768_a("SeatIndex", indexOf);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        boolean solid;
        super.visitNewPosition(context, pos);
        AbstractContraptionEntity contraptionEntity = context.contraption.entity;
        if (contraptionEntity == null) {
            return;
        }
        int index = context.data.func_74762_e("SeatIndex");
        if (index == -1) {
            return;
        }
        Map<UUID, Integer> seatMapping = context.contraption.getSeatMapping();
        BlockState blockState = context.world.func_180495_p(pos);
        boolean slab = blockState.func_177230_c() instanceof SlabBlock && blockState.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM;
        boolean bl = solid = blockState.func_200132_m() || slab;
        if (seatMapping.containsValue(index)) {
            if (!solid) {
                return;
            }
            Entity toDismount = null;
            for (Map.Entry<UUID, Integer> entry : seatMapping.entrySet()) {
                if (entry.getValue() != index) continue;
                for (Entity entity : contraptionEntity.func_184188_bt()) {
                    if (!entry.getKey().equals(entity.func_110124_au())) continue;
                    toDismount = entity;
                }
            }
            if (toDismount != null) {
                toDismount.func_184210_p();
                Vector3d position = VecHelper.getCenterOf((Vector3i)pos).func_72441_c(0.0, slab ? 0.5 : 1.0, 0.0);
                toDismount.func_70634_a(position.field_72450_a, position.field_72448_b, position.field_72449_c);
                toDismount.getPersistentData().func_82580_o("ContraptionDismountLocation");
            }
            return;
        }
        if (solid) {
            return;
        }
        List nearbyEntities = context.world.func_175647_a(Entity.class, new AxisAlignedBB(pos).func_186664_h(0.0625), SeatBlock::canBePickedUp);
        if (!nearbyEntities.isEmpty()) {
            contraptionEntity.addSittingPassenger((Entity)nearbyEntities.get(0), index);
        }
    }
}

