/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PortableStorageInterfaceTileEntity
extends SmartTileEntity {
    protected int transferTimer = 0;
    protected float distance;
    protected LerpedFloat connectionAnimation = LerpedFloat.linear().startWithValue(0.0);
    protected boolean powered = false;
    protected Entity connectedEntity;
    protected AxisAlignedBB cachedBoundingBox;

    public PortableStorageInterfaceTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void startTransferringTo(Contraption contraption, float distance) {
        this.distance = distance;
        this.connectedEntity = contraption.entity;
        this.startConnecting();
        this.notifyUpdate();
    }

    protected void stopTransferring() {
        this.connectedEntity = null;
    }

    public boolean canTransfer() {
        if (this.connectedEntity != null && !this.connectedEntity.func_70089_S()) {
            this.stopTransferring();
        }
        return this.connectedEntity != null && this.isConnected();
    }

    protected abstract void invalidateCapability();

    @Override
    public void func_73660_a() {
        boolean isConnected;
        super.func_73660_a();
        boolean wasConnected = this.isConnected();
        int timeUnit = this.getTransferTimeout() / 2;
        if (!(this.transferTimer <= 0 || this.isVirtual() && this.transferTimer == timeUnit)) {
            --this.transferTimer;
            if (this.transferTimer == 0 || this.powered) {
                this.stopTransferring();
            }
        }
        if (wasConnected != (isConnected = this.isConnected()) && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
        float progress = 0.0f;
        if (isConnected) {
            progress = 1.0f;
        } else if (this.transferTimer >= timeUnit * 3) {
            progress = MathHelper.func_219799_g((float)((float)(this.transferTimer - timeUnit * 3) / (float)timeUnit), (float)1.0f, (float)0.0f);
        } else if (this.transferTimer < timeUnit) {
            progress = MathHelper.func_219799_g((float)((float)this.transferTimer / (float)timeUnit), (float)0.0f, (float)1.0f);
        }
        this.connectionAnimation.setValue(progress);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateCapability();
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.transferTimer = compound.func_74762_e("Timer");
        this.distance = compound.func_74760_g("Distance");
        this.powered = compound.func_74767_n("Powered");
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("Timer", this.transferTimer);
        compound.func_74776_a("Distance", this.distance);
        compound.func_74757_a("Powered", this.powered);
    }

    public void neighbourChanged() {
        boolean isBlockPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (isBlockPowered == this.powered) {
            return;
        }
        this.powered = isBlockPowered;
        this.sendData();
    }

    public boolean isPowered() {
        return this.powered;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cachedBoundingBox == null) {
            this.cachedBoundingBox = super.getRenderBoundingBox().func_186662_g(2.0);
        }
        return this.cachedBoundingBox;
    }

    public boolean isTransferring() {
        return this.transferTimer != 0;
    }

    boolean isConnected() {
        int timeUnit = this.getTransferTimeout() / 2;
        return this.transferTimer >= timeUnit && this.transferTimer <= timeUnit * 3;
    }

    float getExtensionDistance(float partialTicks) {
        return this.connectionAnimation.getValue(partialTicks) * this.distance / 2.0f;
    }

    float getConnectionDistance() {
        return this.distance;
    }

    public void startConnecting() {
        this.transferTimer = this.getTransferTimeout() * 2;
    }

    public void onContentTransferred() {
        int timeUnit = this.getTransferTimeout() / 2;
        this.transferTimer = timeUnit * 3;
        this.sendData();
    }

    protected Integer getTransferTimeout() {
        return (Integer)AllConfigs.SERVER.logistics.psiTimeout.get();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

