/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.protocol;

import dark.org.http.HttpException;
import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseInterceptor;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.protocol.HttpContext;
import dark.org.http.protocol.HttpDateGenerator;
import dark.org.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

