/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.cookie;

import dark.org.http.FormattedHeader;
import dark.org.http.Header;
import dark.org.http.HeaderElement;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.Obsolete;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.cookie.CommonCookieAttributeHandler;
import dark.org.http.cookie.Cookie;
import dark.org.http.cookie.CookieOrigin;
import dark.org.http.cookie.MalformedCookieException;
import dark.org.http.impl.cookie.BasicCommentHandler;
import dark.org.http.impl.cookie.BasicExpiresHandler;
import dark.org.http.impl.cookie.BasicPathHandler;
import dark.org.http.impl.cookie.BasicSecureHandler;
import dark.org.http.impl.cookie.CookieSpecBase;
import dark.org.http.impl.cookie.NetscapeDomainHandler;
import dark.org.http.impl.cookie.NetscapeDraftHeaderParser;
import dark.org.http.message.BufferedHeader;
import dark.org.http.message.ParserCursor;
import dark.org.http.util.Args;
import dark.org.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.List;

@Obsolete
@Contract(threading=ThreadingBehavior.SAFE)
public class NetscapeDraftSpec
extends CookieSpecBase {
    protected static final String EXPIRES_PATTERN = "EEE, dd-MMM-yy HH:mm:ss z";

    public NetscapeDraftSpec(String[] datepatterns) {
        String[] stringArray;
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[1] = new NetscapeDomainHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (datepatterns != null) {
            stringArray = (String[])datepatterns.clone();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = EXPIRES_PATTERN;
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
        super(commonCookieAttributeHandlerArray);
    }

    NetscapeDraftSpec(CommonCookieAttributeHandler ... handlers) {
        super(handlers);
    }

    public NetscapeDraftSpec() {
        this((String[])null);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        ParserCursor cursor;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            cursor = new ParserCursor(0, buffer.length());
        }
        return this.parse(new HeaderElement[]{parser.parseHeader(buffer, cursor)}, origin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notEmpty(cookies, "List of cookies");
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            buffer.append(cookie.getName());
            String s = cookie.getValue();
            if (s == null) continue;
            buffer.append("=");
            buffer.append(s);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "netscape";
    }
}

