/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.DataListLoader;
import com.darkere.crashutils.Screens.Types.DropDownType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class DataListGUI
extends CUContentPane {
    CUDropDown SELECTOR;
    DataListLoader loader;
    TextFieldWidget filterWidget;

    DataListGUI(CUScreen screen, RegistryKey<World> dim) {
        super(dim, screen);
        this.updateRenderValues(screen.centerX, screen.centerY);
        this.loader = new DataListLoader(this.XTopLeft, this.YTopLeft, this.XAcross, this.YAcross, screen, dim);
        DataHolder.setRequestType(DataRequestType.ENTITYDATA);
        DataHolder.requestUpdates(0, dim, true);
        this.SELECTOR = new CUDropDown(DropDownType.SELECTOR, screen, Arrays.asList("ENTITIES", "TILEENTITIES", "TICKETS", "STATES", "PLAYERS"), "ENTITIES", -192, -105, 75);
        screen.topDropDowns.add(this.SELECTOR);
        this.SELECTOR.setEnabled(true);
        this.loader.loadOrderedEntityList(false);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Minecraft.func_71410_x().field_71466_p.getClass();
        this.filterWidget = new TextFieldWidget(fontRenderer, this.centerX - 107, this.centerY - 104, 150, 9 + 2, (ITextComponent)new StringTextComponent("Filter"));
        this.filterWidget.func_212954_a(r -> this.loader.currentList.updateFilter((String)r));
    }

    @Override
    public void render(MatrixStack stack, int centerX, int centerY, int mx, int my, float partialTicks) {
        super.render(stack, centerX, centerY, mx, my, partialTicks);
        this.loader.currentList.render(stack, mx, my, partialTicks);
        this.filterWidget.func_230430_a_(stack, mx, my, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mx, double my, int mouseButton) {
        return this.loader.currentList.checkClick((int)mx, (int)my);
    }

    @Override
    public boolean mouseClickedOutside(double mx, double my, int centerX, int centerY) {
        return this.filterWidget.func_231044_a_(mx, my, 0);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.filterWidget.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return this.filterWidget.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public void scroll(double x, double y, double delta, int centerX, int centerY) {
        this.loader.currentList.scroll(x, y, delta);
    }

    @Override
    public void updateSelection(DropDownType ddtype, String s) {
        if (ddtype == DropDownType.SELECTOR) {
            switch (s) {
                case "ENTITIES": {
                    DataHolder.setRequestType(DataRequestType.ENTITYDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstEntity);
                    this.currentType = DataRequestType.ENTITYDATA;
                    this.firstEntity = true;
                    this.loader.loadOrderedEntityList(false);
                    break;
                }
                case "TILEENTITIES": {
                    DataHolder.setRequestType(DataRequestType.TILEENTITYDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstTileEntity);
                    this.currentType = DataRequestType.TILEENTITYDATA;
                    this.firstTileEntity = true;
                    this.loader.loadOrderedTileEntityList(false);
                    break;
                }
                case "TICKETS": {
                    DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstChunks);
                    this.firstChunks = true;
                    this.loader.loadTicketList(false);
                    break;
                }
                case "STATES": {
                    DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstChunks);
                    this.firstChunks = true;
                    this.loader.loadStateList(false);
                    break;
                }
                case "PLAYERS": {
                    DataHolder.setRequestType(DataRequestType.PLAYERDATA);
                    DataHolder.requestUpdates(0, this.screen.dim, !this.firstPlayer);
                    this.firstPlayer = true;
                    this.loader.loadPlayerList(false);
                }
            }
        }
    }
}

