/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.DataStructures.DataHolder;
import com.darkere.crashutils.Network.DataRequestType;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.TeleportMessage;
import com.darkere.crashutils.Screens.CUContentPane;
import com.darkere.crashutils.Screens.CUDropDown;
import com.darkere.crashutils.Screens.CUTab;
import com.darkere.crashutils.Screens.DataListGUI;
import com.darkere.crashutils.Screens.MapGUI;
import com.darkere.crashutils.Screens.Types.DropDownType;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class CUScreen
extends Screen {
    public static CUScreen stored;
    CUContentPane contentGUI;
    long doubleClickTimer;
    double oldClickX;
    double OldClickY;
    RegistryKey<World> dim;
    int centerX;
    int centerY;
    int activeTab = 0;
    int tabs = 2;
    private static final ResourceLocation WINDOW;
    private static final ResourceLocation TABS;
    public List<CUDropDown> topDropDowns = new ArrayList<CUDropDown>();
    ExtendedButton button;
    ExtendedButton backButton;
    boolean dragging;
    BlockPos initial;
    static boolean keep;

    public CUScreen(RegistryKey<World> worldKey, BlockPos position) {
        super((ITextComponent)new StringTextComponent("CUScreen"));
        this.dim = worldKey;
        this.initial = position;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.centerY = this.field_230709_l_ / 2;
        this.centerX = this.field_230708_k_ / 2;
        if (!keep) {
            this.contentGUI = new MapGUI(this, this.dim, this.initial);
            DataHolder.setRequestType(DataRequestType.LOADEDCHUNKDATA);
        }
        this.button = new ExtendedButton(this.centerX + 174, this.centerY - 103, 20, 10, (ITextComponent)new StringTextComponent(String.valueOf(this.contentGUI.updateSpeed)), x -> {
            this.contentGUI.shouldUpdate = !this.contentGUI.shouldUpdate;
            this.contentGUI.setUpdateSpeed();
        });
        this.func_230480_a_((Widget)this.button);
        this.backButton = new ExtendedButton(this.centerX + 145, this.centerY - 103, 20, 10, (ITextComponent)new StringTextComponent("<-"), button -> {
            if (this.contentGUI instanceof DataListGUI) {
                ((DataListGUI)this.contentGUI).loader.goBack();
            } else if (this.contentGUI instanceof MapGUI) {
                ((MapGUI)this.contentGUI).goTo(((MapGUI)this.contentGUI).initial);
            }
        });
        this.func_230480_a_((Widget)this.backButton);
    }

    public void func_230446_a_(MatrixStack stack) {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
        int i = this.centerX - 200;
        int j = this.centerY - 108;
        CUScreen.func_238463_a_((MatrixStack)stack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)400, (int)216, (int)512, (int)512);
        this.renderTabs(stack);
    }

    public void func_230430_a_(MatrixStack stack, int mx, int my, float partialTicks) {
        this.func_230446_a_(stack);
        this.contentGUI.render(stack, this.centerX, this.centerY, mx, my, partialTicks);
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        CUScreen.func_238467_a_((MatrixStack)stack, (int)(this.centerX + 173), (int)(this.centerY - 105), (int)(this.centerX + 195), (int)(this.centerY - 93), (int)(this.contentGUI.shouldUpdate ? -11406014 : -703934));
        this.button.field_230690_l_ = this.centerX + 174;
        this.button.field_230691_m_ = this.centerY - 104;
        this.backButton.field_230690_l_ = this.centerX + 145;
        this.backButton.field_230691_m_ = this.centerY - 103;
        this.topDropDowns.forEach(x -> x.render(stack, this.centerX, this.centerY));
        this.renderToolTips(stack, mx, my);
        this.button.func_230431_b_(stack, mx, my, partialTicks);
        this.backButton.func_230431_b_(stack, mx, my, partialTicks);
        super.func_230430_a_(stack, mx, my, partialTicks);
    }

    private void renderToolTips(MatrixStack stack, int mx, int my) {
        ArrayList<StringTextComponent> tooltips = new ArrayList<StringTextComponent>();
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY) && this.contentGUI instanceof MapGUI) {
            MapGUI gui = (MapGUI)this.contentGUI;
            ChunkPos chunkPos = gui.getChunkFor(mx, my);
            tooltips.add(new StringTextComponent("Chunk: X: " + chunkPos.field_77276_a + " Z: " + chunkPos.field_77275_b));
            String loc = gui.getLocFor(mx, my);
            tooltips.add(new StringTextComponent("State: " + gui.getNameForLocationType(loc)));
            StringBuilder builder = new StringBuilder();
            switch (gui.type) {
                case TICKET: 
                case LOCATIONTYPE: {
                    builder.append("Tickets: ");
                    String tickets = gui.getTicketsFor(mx, my);
                    builder.append(tickets == null ? "None" : tickets);
                    break;
                }
                case ENTITIES: {
                    builder.append("Entities: ");
                    String entities = gui.getEntityCountFor(mx, my);
                    builder.append(entities == null ? "None" : entities);
                    break;
                }
                case TILEENTITIES: {
                    builder.append("Tileentities: ");
                    String tileEntities = gui.getTileEntityCountFor(mx, my);
                    builder.append(tileEntities == null ? "None" : tileEntities);
                }
            }
            tooltips.add(new StringTextComponent(builder.toString()));
            tooltips.add(new StringTextComponent("(Double click to teleport)"));
        }
        if (this.button.func_231047_b_((double)mx, (double)my)) {
            tooltips.add(new StringTextComponent("Requesting data every " + this.contentGUI.updateSpeed + " seconds"));
            tooltips.add(new StringTextComponent("Currently " + (this.contentGUI.shouldUpdate ? "enabled" : "disabled")));
            tooltips.add(new StringTextComponent("Scroll to change update Speed"));
            tooltips.add(new StringTextComponent("(It may be possible to lag a server using this)"));
        }
        if (this.backButton.func_231047_b_((double)mx, (double)my)) {
            tooltips.add(new StringTextComponent(this.contentGUI instanceof MapGUI ? "Return to player" : "Go Back"));
        }
        if (!tooltips.isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)stack, tooltips, (int)mx, (int)my, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)150, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    private void renderTabs(MatrixStack stack) {
        int x = this.centerX - 200;
        int y = this.centerY - 108 - 22;
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(TABS);
        float iconScale = 3.75f;
        ArrayList<CUTab> tabIcons = new ArrayList<CUTab>();
        tabIcons.add(CUTab.MAPTABICON);
        tabIcons.add(CUTab.LISTTABICON);
        tabIcons.add(CUTab.INVSEETABICON);
        for (int i = 0; i < this.tabs; ++i) {
            if (i == 0) {
                if (i == this.activeTab) {
                    CUTab.ATL.drawTab(stack, (AbstractGui)this, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                    continue;
                }
                CUTab.ITL.drawTab(stack, (AbstractGui)this, x, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            if (i == this.activeTab) {
                CUTab.ATC.drawTab(stack, (AbstractGui)this, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
                continue;
            }
            CUTab.ITC.drawTab(stack, (AbstractGui)this, x + i * 27, y, (CUTab)((Object)tabIcons.get(i)), iconScale);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        DataHolder.cancelTimer();
        DataHolder.stopListening();
        stored = this;
    }

    public boolean func_231045_a_(double XStart, double YStart, int Button2, double XDif, double YDif) {
        if (this.dragging) {
            this.contentGUI.addOffset(-XDif, -YDif);
            return true;
        }
        return super.func_231045_a_(XStart, YStart, Button2, XDif, YDif);
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (p_mouseReleased_5_ == 0) {
            this.dragging = false;
        }
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean func_231044_a_(double mx, double my, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        for (CUDropDown dropDown : this.topDropDowns) {
            if (!dropDown.checkClick((int)mx, (int)my)) continue;
            return true;
        }
        if (this.contentGUI.mouseClickedOutside(mx, my, this.centerX, this.centerY)) {
            return true;
        }
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
            this.dragging = true;
            if (this.contentGUI.mouseClicked(mx, my, mouseButton)) {
                return true;
            }
        }
        if (my > (double)(this.centerY - 126) && my < (double)(this.centerY - 107)) {
            return this.clickedTabArea(mx, my, mouseButton);
        }
        if (Instant.now().getEpochSecond() - this.doubleClickTimer < 1L) {
            if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
                if (Math.sqrt((this.oldClickX - mx) * (this.oldClickX - mx) + (this.OldClickY - my) * (this.OldClickY - my)) > 5.0) {
                    return super.func_231044_a_(mx, my, mouseButton);
                }
                if (this.contentGUI instanceof MapGUI) {
                    MapGUI gui = (MapGUI)this.contentGUI;
                    BlockPos pos = gui.getChunkFor((int)mx, (int)my).func_206849_h();
                    Network.sendToServer(new TeleportMessage(this.dim, this.dim, pos));
                    return true;
                }
            }
        } else {
            this.doubleClickTimer = Instant.now().getEpochSecond();
            this.oldClickX = mx;
            this.OldClickY = my;
        }
        return super.func_231044_a_(mx, my, mouseButton);
    }

    private boolean clickedTabArea(double mx, double my, int mouseButton) {
        int x = (int)mx - (this.centerX - 198);
        int tab = x / 27;
        if (tab >= this.tabs) {
            return false;
        }
        this.activeTab = tab;
        this.switchTabs();
        return true;
    }

    private void switchTabs() {
        this.topDropDowns.clear();
        switch (this.activeTab) {
            case 0: {
                this.contentGUI = new MapGUI(this, this.dim, this.initial);
                keep = false;
                break;
            }
            case 1: {
                this.contentGUI = new DataListGUI(this, this.dim);
                keep = true;
            }
        }
    }

    public boolean func_231043_a_(double mx, double my, double delta) {
        if (this.button.func_231047_b_(mx, my)) {
            if (delta > 0.0 && this.contentGUI.updateSpeed < 5) {
                ++this.contentGUI.updateSpeed;
            } else if (delta > 0.0 && this.contentGUI.updateSpeed < 60) {
                this.contentGUI.updateSpeed += 5;
            } else if (delta < 0.0 && this.contentGUI.updateSpeed > 5) {
                this.contentGUI.updateSpeed -= 5;
            } else if (delta < 0.0 && this.contentGUI.updateSpeed <= 5 && this.contentGUI.updateSpeed > 1) {
                --this.contentGUI.updateSpeed;
            }
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.contentGUI.updateSpeed)));
            this.contentGUI.setUpdateSpeed();
            return true;
        }
        if (this.contentGUI.isMouseOver(mx, my, this.centerX, this.centerY)) {
            for (CUDropDown dropDown : this.topDropDowns) {
                if (!dropDown.scroll(mx, my, delta)) continue;
                return true;
            }
            this.contentGUI.scroll(mx, my, delta, this.centerX, this.centerY);
            return true;
        }
        return super.func_231043_a_(mx, my, delta);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.contentGUI.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.contentGUI.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public void updateSelection(DropDownType ddtype, String s) {
        this.contentGUI.updateSelection(ddtype, s);
    }

    public static CUScreen openCUScreen(RegistryKey<World> world, BlockPos pos) {
        if (stored == null || !keep || !world.equals(CUScreen.stored.dim)) {
            keep = false;
            stored = new CUScreen(world, pos);
        }
        DataHolder.notifyListener();
        return stored;
    }

    static {
        WINDOW = new ResourceLocation("crashutilities", "textures/gui/cuscreen.png");
        TABS = new ResourceLocation("crashutilities", "textures/gui/tabs.png");
        keep = false;
    }
}

