/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.OpenPlayerInvMessage;
import com.darkere.crashutils.Screens.PlayerInvContainer;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PlayerInventoryRequestMessage {
    String playerName;

    public PlayerInventoryRequestMessage(String s) {
        this.playerName = s;
    }

    public static void encode(PlayerInventoryRequestMessage data, PacketBuffer buf) {
        buf.writeInt(data.playerName.length());
        buf.func_180714_a(data.playerName);
    }

    public static PlayerInventoryRequestMessage decode(PacketBuffer buf) {
        return new PlayerInventoryRequestMessage(buf.func_150789_c(buf.readInt()));
    }

    public static boolean handle(PlayerInventoryRequestMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            MinecraftServer server = player.func_184102_h();
            if (!player.func_211513_k(2)) {
                return;
            }
            ServerPlayerEntity otherPlayer = ((NetworkEvent.Context)ctx.get()).getSender().func_184102_h().func_184103_al().func_152612_a(data.playerName);
            if (otherPlayer == null) {
                GameProfile profile = server.func_152358_ax().func_152655_a(data.playerName);
                if (profile == null) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Cannot find Player"), new UUID(0L, 0L));
                    return;
                }
                otherPlayer = new FakePlayer(server.func_71218_a(World.field_234918_g_), profile);
                CompoundNBT nbt = server.field_240766_e_.func_237336_b_((PlayerEntity)otherPlayer);
                if (nbt == null) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Cannot load playerData"), new UUID(0L, 0L));
                    return;
                }
                otherPlayer.func_70020_e(nbt);
            }
            LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
            if (CrashUtils.curiosLoaded) {
                ((ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)otherPlayer).orElse(null)).getCurios().forEach((s, handler) -> curios.put((String)s, handler.getSlots()));
            }
            player.func_71128_l();
            player.func_71117_bO();
            int id = player.field_71139_cq;
            Network.sendToPlayer(player, new OpenPlayerInvMessage(id, data.playerName, curios));
            player.field_71070_bA = new PlayerInvContainer((PlayerEntity)player, (PlayerEntity)otherPlayer, id, null, null, 0);
            player.field_71070_bA.func_75132_a((IContainerListener)player);
        });
        return true;
    }
}

