/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CrashUtils;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.FilenameUtils;

public class PlayerActivityHistory {
    List<String> month = new ArrayList<String>();
    List<String> week = new ArrayList<String>();
    List<String> day = new ArrayList<String>();
    List<String> playersInChunkClearTime = new ArrayList<String>();
    private static final long monthTime = 2629743L;
    private static final long weekTime = 604800L;
    private static final long dayTime = 86400L;
    private static final long chunkcleanertimer = 86400L * (long)CrashUtils.SERVER_CONFIG.getExpireTimeInDays();

    public PlayerActivityHistory(ServerWorld world) {
        long current = Instant.now().getEpochSecond();
        try {
            Files.list(world.func_73046_m().field_240766_e_.getPlayerDataFolder().toPath()).forEach(x -> {
                if (x.toFile().isDirectory() || x.getFileName().toString().endsWith("old") || !x.getFileName().toString().endsWith("dat")) {
                    return;
                }
                long fileTime = 0L;
                try {
                    fileTime = Files.getLastModifiedTime(x, LinkOption.NOFOLLOW_LINKS).toInstant().getEpochSecond();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                long diff = current - fileTime;
                if (diff < 2629743L) {
                    UUID uuid;
                    String uuidText = FilenameUtils.removeExtension((String)x.getFileName().toString());
                    try {
                        uuid = UUID.fromString(uuidText);
                    }
                    catch (IllegalArgumentException ignored) {
                        return;
                    }
                    GameProfile profile = world.func_73046_m().func_152358_ax().func_152652_a(uuid);
                    if (profile == null) {
                        return;
                    }
                    String playerName = profile.getName();
                    this.month.add(playerName);
                    if (diff < 604800L) {
                        this.week.add(playerName);
                        if (diff < 86400L) {
                            this.day.add(playerName);
                        }
                    }
                    if (diff > chunkcleanertimer) {
                        this.playersInChunkClearTime.add(playerName);
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getMonth() {
        return this.month;
    }

    public List<String> getWeek() {
        return this.week;
    }

    public List<String> getDay() {
        return this.day;
    }

    public List<String> getPlayersInChunkClearTime() {
        return this.playersInChunkClearTime;
    }
}

