/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.LocationData;
import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityData
extends LocationData {
    public EntityData() {
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            this.map.put(((RegistryKey)entry.getKey()).func_240901_a_(), new ArrayList());
        }
    }

    public EntityData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public void createLists(List<ServerWorld> worlds) {
        ArrayList entities = new ArrayList();
        worlds.forEach(x -> entities.addAll(x.getEntities().collect(Collectors.toList())));
        for (Entity entity : entities) {
            ((List)this.map.get(entity.func_200600_R().getRegistryName())).add(WorldPos.getPosFromEntity(entity));
        }
        this.total = entities.size();
    }

    public void reply(ResourceLocation res, CommandSource source) {
        if (res == null) {
            this.map.entrySet().stream().filter(x -> ((List)x.getValue()).size() != 0).sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(e -> CommandUtils.sendFindEMessage(source, (ResourceLocation)e.getKey(), ((List)e.getValue()).size()));
            CommandUtils.sendNormalMessage(source, this.total + " Entities", TextFormatting.DARK_AQUA);
        } else {
            this.sendEntityChunkMapCommand(source, res);
        }
    }

    private void sendEntityChunkMapCommand(CommandSource source, ResourceLocation res) {
        this.fillChunkMaps(res.toString());
        CommandUtils.sendNormalMessage(source, res.toString(), TextFormatting.DARK_BLUE);
        this.chunkMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(List::size))).forEach(k -> CommandUtils.sendChunkEntityMessage(source, ((List)k.getValue()).size(), ((WorldPos)this.tpPos.get(k.getKey())).pos, ((WorldPos)this.tpPos.get(k.getKey())).type, true));
    }
}

