/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.MemoryChecker;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class MemoryCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"memoryCheck").executes(ctx -> MemoryCommand.run((CommandContext<CommandSource>)ctx, 10))).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> MemoryCommand.run((CommandContext<CommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))));
    }

    private static int run(CommandContext<CommandSource> context, int count) {
        if (!CrashUtils.SERVER_CONFIG.getMemoryChecker()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Memory Checker not enabled in Config"), true);
            return 0;
        }
        List<MemoryChecker.MemoryCount> full = MemoryChecker.INSTANCE.counts;
        if (full.size() < count) {
            count = full.size();
        }
        for (int i = full.size() - count; i < full.size(); ++i) {
            ((CommandSource)context.getSource()).func_197030_a(MemoryCommand.createVisualMemoryText(full.get(i)), true);
        }
        return 1;
    }

    private static ITextComponent createVisualMemoryText(MemoryChecker.MemoryCount count) {
        StringTextComponent text = new StringTextComponent("[");
        double maximum = Math.ceil(MemoryChecker.inGigaBytes(count.getMaximum()));
        double total = MemoryChecker.inGigaBytes(count.getTotal());
        double used = total - MemoryChecker.inGigaBytes(count.getFree());
        double percentTotal = total / maximum;
        double percentUsed = used / maximum;
        for (double i = 0.1; i <= 1.0; i += 0.1) {
            if (i < percentUsed) {
                text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent("I", TextFormatting.RED));
                continue;
            }
            if (i < percentTotal) {
                text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent("I", TextFormatting.YELLOW));
                continue;
            }
            text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent("I", TextFormatting.GREEN));
        }
        int usedpercent = (int)(percentUsed * 100.0);
        int allocatedpercent = (int)(percentTotal * 100.0);
        text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent("] " + usedpercent + " % Used " + allocatedpercent + " % Allocated", TextFormatting.WHITE));
        return text;
    }
}

