/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.LogHandler;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GetLogCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"log").executes(GetLogCommand::getLogOverview)).then(Commands.func_197057_a((String)"uploadCrashReport").executes(GetLogCommand::uploadCrashReport))).then(Commands.func_197057_a((String)"uploadLatestLog").executes(GetLogCommand::uploadLatestLog))).then(Commands.func_197057_a((String)"uploadArchivedLog").executes(GetLogCommand::uploadArchivedLog));
    }

    private static int uploadArchivedLog(CommandContext<CommandSource> context) {
        Path archivedLog = LogHandler.getLatestArchivedLogPath();
        if (archivedLog != null) {
            GetLogCommand.uploadString(context, archivedLog, LogHandler.getStringFromArchive(archivedLog));
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("No Archived Log found"), true);
        }
        return 1;
    }

    private static void uploadString(CommandContext<CommandSource> context, Path logPath, String text) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Uploading..."), false);
        String description = "Log Created " + LogHandler.getRelativePathDateInMin(logPath) + "min before upload";
        String url = LogHandler.uploadLog(description, logPath.getFileName().toString(), text);
        if (url.startsWith("https")) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)CommandUtils.createURLComponent(url, url), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Upload Failed: " + url), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Try again or use Copy"), true);
        }
    }

    private static int uploadLatestLog(CommandContext<CommandSource> context) {
        Path latestLog = LogHandler.latestlog;
        GetLogCommand.uploadString(context, latestLog, LogHandler.getFileAsStringFromPath(latestLog));
        return 1;
    }

    private static int uploadCrashReport(CommandContext<CommandSource> context) {
        Path crashreport = LogHandler.getLatestCrashReportPath();
        if (crashreport == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("No crash report found"), true);
            return 1;
        }
        GetLogCommand.uploadString(context, crashreport, LogHandler.getFileAsStringFromPath(crashreport));
        return 1;
    }

    private static int getLogOverview(CommandContext<CommandSource> ctx) {
        Path archivedLog;
        IFormattableTextComponent latestlogText = new StringTextComponent("Log from current Game").func_240699_a_(TextFormatting.YELLOW);
        latestlogText.func_230529_a_((ITextComponent)CommandUtils.getCommandTextComponent(" [Upload]", "/cu log uploadLatestLog"));
        latestlogText.func_230529_a_((ITextComponent)CommandUtils.createCopyComponent(" [Copy]", LogHandler.getFileAsStringFromPath(LogHandler.latestlog)));
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)latestlogText, true);
        Path crashreport = LogHandler.getLatestCrashReportPath();
        if (crashreport != null) {
            IFormattableTextComponent crashreporttext = new StringTextComponent("Latest Crash Report ").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent(LogHandler.getRelativePathDateInMin(crashreport) + " Minutes old").func_240699_a_(TextFormatting.AQUA));
            crashreporttext.func_230529_a_((ITextComponent)CommandUtils.getCommandTextComponent(" [Upload]", "/cu log uploadCrashReport"));
            crashreporttext.func_230529_a_((ITextComponent)CommandUtils.createCopyComponent(" [Copy]", LogHandler.getFileAsStringFromPath(crashreport)));
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)crashreporttext, true);
        }
        if ((archivedLog = LogHandler.getLatestArchivedLogPath()) != null) {
            IFormattableTextComponent archivedText = new StringTextComponent("Archived Latest.log ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new StringTextComponent(LogHandler.getRelativePathDateInMin(archivedLog) + " Minutes old").func_240699_a_(TextFormatting.AQUA));
            archivedText.func_230529_a_((ITextComponent)CommandUtils.getCommandTextComponent(" [Upload]", "/cu log uploadArchivedLog"));
            archivedText.func_230529_a_((ITextComponent)CommandUtils.createCopyComponent(" [Copy]", LogHandler.getStringFromArchive(archivedLog)));
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)archivedText, true);
        }
        return 1;
    }
}

