/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.DataStructures.WorldPos;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandUtils {
    public static final int PERMISSION_LEVEL = 2;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SuggestionProvider<CommandSource> PROFILEPROVIDER = (ctx, builder) -> ISuggestionProvider.func_197013_a(((CommandSource)ctx.getSource()).func_197028_i().func_152358_ax().func_242117_a(1000).map(e -> e.func_152668_a().getName()), (SuggestionsBuilder)builder);

    public static void sendNormalMessage(CommandSource source, String msg, TextFormatting color) {
        StringTextComponent text = new StringTextComponent(msg);
        Style style = Style.field_240709_b_;
        text = text.func_230530_a_(style);
        text.func_240699_a_(color);
        source.func_197030_a((ITextComponent)text, true);
    }

    public static void sendCommandMessage(CommandSource source, IFormattableTextComponent text, String command, boolean runDirectly) {
        Style style = text.func_150256_b();
        ClickEvent click = new ClickEvent(runDirectly ? ClickEvent.Action.RUN_COMMAND : ClickEvent.Action.SUGGEST_COMMAND, command);
        style = style.func_240717_a_(style.func_240715_a_(click));
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to execute \u00a76" + command + "\u00a7r"));
        style = style.func_240717_a_(style.func_240716_a_(hoverEvent));
        IFormattableTextComponent tex = text.func_230530_a_(style);
        source.func_197030_a((ITextComponent)tex, false);
        LOGGER.info(text.getString() + " " + command);
    }

    public static void sendTEMessage(CommandSource source, WorldPos worldPos, boolean runDirectly) {
        BlockPos pos = worldPos.pos;
        String position = " - [" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]";
        IFormattableTextComponent text = new StringTextComponent(position).func_240699_a_(TextFormatting.GREEN);
        ServerPlayerEntity player = null;
        try {
            player = source.func_197035_h();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tp " + (player != null ? player.func_200200_C_().getString() : "Console") + " " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p() + " " + worldPos.type.func_240901_a_(), runDirectly);
    }

    public static void sendFindTEMessage(CommandSource source, ResourceLocation res, int count, boolean ticking) {
        IFormattableTextComponent text = new StringTextComponent(res.toString()).func_240699_a_(TextFormatting.AQUA);
        text.func_230529_a_((ITextComponent)new StringTextComponent(" Count ").func_240699_a_(TextFormatting.DARK_RED));
        text.func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(count)).func_240699_a_(TextFormatting.GREEN));
        if (ticking) {
            text.func_230529_a_((ITextComponent)new StringTextComponent(" ticking").func_240699_a_(TextFormatting.RED));
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tileentities find " + res.toString(), true);
    }

    public static void sendChunkEntityMessage(CommandSource source, int count, BlockPos pos, RegistryKey<World> type, boolean runDirectly) {
        IFormattableTextComponent text = new StringTextComponent("- " + pos.toString()).func_240699_a_(TextFormatting.GREEN);
        text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent(" Count ", TextFormatting.RED));
        text.func_230529_a_((ITextComponent)CommandUtils.coloredComponent(Integer.toString(count), TextFormatting.GREEN));
        ServerPlayerEntity player = null;
        try {
            player = source.func_197035_h();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        CommandUtils.sendCommandMessage(source, text, "/cu tp " + (player != null ? player.func_200200_C_().getString() : "Console") + " " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p() + " " + type.func_240901_a_(), runDirectly);
    }

    public static void sendFindEMessage(CommandSource source, ResourceLocation res, int count) {
        IFormattableTextComponent text = new StringTextComponent(String.valueOf(count)).func_240699_a_(TextFormatting.BLUE);
        text.func_230529_a_((ITextComponent)new StringTextComponent("x ").func_240699_a_(TextFormatting.YELLOW));
        text.func_230529_a_((ITextComponent)new StringTextComponent(res.toString()).func_240699_a_(TextFormatting.AQUA));
        CommandUtils.sendCommandMessage(source, text, "/cu entities find " + res.toString(), true);
    }

    public static IFormattableTextComponent coloredComponent(String text, TextFormatting color) {
        return new StringTextComponent(text).func_240699_a_(color);
    }

    public static void sendItemInventoryRemovalMessage(CommandSource source, String name, ItemStack itemStack, String inventoryType, int i) {
        IFormattableTextComponent text = new StringTextComponent("[" + i + "] ").func_240699_a_(TextFormatting.DARK_BLUE);
        text.func_230529_a_(itemStack.func_151000_E());
        String Command = "/cu inventory remove " + name + " " + inventoryType + " " + i;
        CommandUtils.sendCommandMessage(source, text, Command, false);
    }

    public static IFormattableTextComponent createURLComponent(String display, String url) {
        StringTextComponent text = new StringTextComponent(display);
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Go to " + url));
        Style style = Style.field_240709_b_;
        style = style.func_240717_a_(style.func_240715_a_(clickEvent));
        style = style.func_240717_a_(style.func_240716_a_(hoverEvent));
        text.func_230530_a_(style);
        return text;
    }

    public static IFormattableTextComponent createCopyComponent(String display, String toCopy) {
        StringTextComponent text = new StringTextComponent(display);
        Style style = Style.field_240709_b_;
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Copy Contents to Clipboard"));
        style = style.func_240717_a_(style.func_240715_a_(clickEvent));
        style = style.func_240717_a_(style.func_240716_a_(hoverEvent));
        text.func_230530_a_(style);
        text.func_240699_a_(TextFormatting.GREEN);
        return text;
    }

    public static IFormattableTextComponent getCommandTextComponent(String display, String command) {
        StringTextComponent text = new StringTextComponent(display);
        Style style = Style.field_240709_b_;
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to execute \u00a76" + command + "\u00a7r"));
        style = style.func_240717_a_(style.func_240715_a_(clickEvent));
        style = style.func_240717_a_(style.func_240716_a_(hoverEvent));
        text.func_230530_a_(style);
        text.func_240699_a_(TextFormatting.GOLD);
        return text;
    }
}

