/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.CrashUtils;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Util;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class ClearItemTask
extends TimerTask {
    public static ClearItemTask INSTANCE;
    int maxItems;
    List<Integer> list = new ArrayList<Integer>();
    Timer timer;
    public int lastCount;

    public static void start() {
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    public static void restart() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            INSTANCE = new ClearItemTask();
            INSTANCE.loadConfigsAndStart();
        }
    }

    private void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.list.clear();
        this.maxItems = 5000;
    }

    public void loadConfigsAndStart() {
        if (ClearItemTask.INSTANCE.timer != null) {
            ClearItemTask.INSTANCE.timer.cancel();
        }
        ClearItemTask.INSTANCE.timer = new Timer("CU Clear Item Task", true);
        this.maxItems = CrashUtils.SERVER_CONFIG.getMaximum();
        this.list = CrashUtils.SERVER_CONFIG.getWarnings();
        this.list.sort(Comparator.comparing(Integer::intValue));
        int time = CrashUtils.SERVER_CONFIG.getTimer() * 60 * 1000;
        if (time == 0) {
            time = 10000;
        }
        if (CrashUtils.SERVER_CONFIG.getEnabled()) {
            this.timer.scheduleAtFixedRate((TimerTask)this, time, (long)time);
        }
    }

    @Override
    public void run() {
        CrashUtils.runNextTick(this::runClear);
    }

    private void runClear(final ServerWorld world) {
        List entityList = world.getEntities().filter(x -> x.func_200600_R().equals(EntityType.field_200765_E)).collect(Collectors.toList());
        this.lastCount = entityList.size();
        if (this.lastCount < this.maxItems) {
            return;
        }
        String text = CrashUtils.SERVER_CONFIG.getWarningText();
        int last = this.list.get(this.list.size() - 1);
        for (Integer integer : this.list) {
            if (integer.equals(last)) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        List<Entity> list = world.getEntities().filter(x -> x.func_200600_R().equals(EntityType.field_200765_E)).collect(Collectors.toList());
                        int size = list.size();
                        if (size > ClearItemTask.this.maxItems) {
                            list.forEach(Entity::func_70106_y);
                            world.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent(size + " Items cleared"), ChatType.SYSTEM, Util.field_240973_b_);
                        } else {
                            world.func_73046_m().func_184103_al().func_232641_a_((ITextComponent)new StringTextComponent("Item Clear prevented. Only " + size + " items on the ground"), ChatType.SYSTEM, Util.field_240973_b_);
                        }
                    }
                }, (long)integer.intValue() * 1000L);
            }
            String intText = text.replaceFirst("%", integer.toString());
            IFormattableTextComponent message = new StringTextComponent("[=== ").func_230529_a_((ITextComponent)new StringTextComponent(intText).func_240699_a_(TextFormatting.RED)).func_230529_a_((ITextComponent)new StringTextComponent(" ===]"));
            new Timer().schedule(new TimerTask((ITextComponent)message){
                final /* synthetic */ ITextComponent val$message;
                {
                    this.val$message = iTextComponent;
                }

                @Override
                public void run() {
                    world.func_73046_m().func_184103_al().func_232641_a_(this.val$message, ChatType.SYSTEM, Util.field_240973_b_);
                }
            }, (long)(last - integer) * 1000L);
        }
        if (!CrashUtils.SERVER_CONFIG.getTitle()) {
            return;
        }
        try {
            if (world.func_73046_m().func_184103_al().func_181057_v().size() == 0) {
                return;
            }
            world.func_73046_m().func_195571_aL().func_197054_a().execute("title @a title {\"text\":\"" + CrashUtils.SERVER_CONFIG.getTitleText() + "\",\"color\":\"dark_red\"}", (Object)world.func_73046_m().func_195573_aM());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }
}

