/*
 * Decompiled with CFR 0.152.
 */
package fr.minuskube.pastee;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import dark.org.json.JSONArray;
import dark.org.json.JSONObject;
import fr.minuskube.pastee.data.Paste;
import fr.minuskube.pastee.data.Syntax;
import fr.minuskube.pastee.response.PasteResponse;
import fr.minuskube.pastee.response.Response;
import fr.minuskube.pastee.response.SubmitResponse;
import fr.minuskube.pastee.response.SyntaxResponse;
import fr.minuskube.pastee.response.SyntaxesResponse;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class JPastee {
    private static final String BASE_URL = "https://api.paste.ee/v1";
    private static final Logger LOGGER = Logger.getLogger("JPastee");
    private List<Syntax> syntaxes;
    private String apiKey;

    public JPastee(String apiKey) {
        this.apiKey = apiKey;
        SyntaxesResponse resp = this.listSyntaxes();
        if (!resp.isSuccess()) {
            LOGGER.severe("Unable to retrieve syntaxes: \n" + resp.getErrorString());
        }
        this.syntaxes = resp.getSyntaxes();
    }

    public SubmitResponse submit(Paste paste) {
        String route = "/pastes";
        JSONObject json = new JSONObject();
        json.put("encrypted", paste.isEncrypted());
        json.putOpt("description", paste.getDescription());
        JSONArray sectionsJson = new JSONArray();
        paste.getSections().forEach(section -> {
            JSONObject sectionJson = new JSONObject();
            sectionJson.putOpt("name", section.getName());
            if (section.getSyntax() != null) {
                sectionJson.putOpt("syntax", section.getSyntax().getShortName());
            }
            sectionJson.put("contents", section.getContents());
            sectionsJson.put(sectionJson);
        });
        json.put("sections", sectionsJson);
        try {
            return new SubmitResponse(this.post("/pastes", json).getBody().getObject());
        }
        catch (UnirestException e) {
            return new SubmitResponse(e);
        }
    }

    public PasteResponse getPaste(String id) {
        String route = "/pastes/" + id;
        try {
            return new PasteResponse(this, this.get(route).getBody().getObject());
        }
        catch (UnirestException e) {
            return new PasteResponse(e);
        }
    }

    public Response deletePaste(String id) {
        String route = "/pastes/" + id;
        try {
            return new Response(this.delete(route).getBody().getObject());
        }
        catch (UnirestException e) {
            return new Response(e);
        }
    }

    public SyntaxesResponse listSyntaxes() {
        String route = "/syntaxes";
        try {
            return new SyntaxesResponse(this.get("/syntaxes").getBody().getObject());
        }
        catch (UnirestException e) {
            return new SyntaxesResponse(e);
        }
    }

    public SyntaxResponse getSyntax(int id) {
        String route = "/syntaxes/" + id;
        try {
            return new SyntaxResponse(this.get(route).getBody().getObject());
        }
        catch (UnirestException e) {
            return new SyntaxResponse(e);
        }
    }

    private HttpResponse<JsonNode> get(String route) throws UnirestException {
        return Unirest.get(BASE_URL + route).header("X-Auth-Token", this.apiKey).asJson();
    }

    private HttpResponse<JsonNode> post(String route, JSONObject json) throws UnirestException {
        return Unirest.post(BASE_URL + route).header("X-Auth-Token", this.apiKey).header("Content-Type", "application/json").body(json).asJson();
    }

    private HttpResponse<JsonNode> delete(String route) throws UnirestException {
        return Unirest.delete(BASE_URL + route).header("X-Auth-Token", this.apiKey).asJson();
    }

    public Optional<Syntax> getSyntaxFromName(String name) {
        return this.syntaxes.stream().filter(syntax -> syntax.getName().equalsIgnoreCase(name) || syntax.getShortName().equalsIgnoreCase(name)).findAny();
    }

    public Optional<Syntax> getSyntaxFromId(int id) {
        return this.syntaxes.stream().filter(syntax -> syntax.getId() == id).findAny();
    }

    public List<Syntax> getSyntaxes() {
        return this.syntaxes;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

