/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.nio.protocol;

import dark.org.http.HttpRequest;
import dark.org.http.nio.ContentDecoder;
import dark.org.http.nio.IOControl;
import dark.org.http.nio.protocol.HttpAsyncRequestConsumer;
import dark.org.http.protocol.HttpContext;
import java.io.IOException;
import java.nio.ByteBuffer;

class NullRequestConsumer
implements HttpAsyncRequestConsumer<Object> {
    private final ByteBuffer buffer = ByteBuffer.allocate(2048);
    private volatile boolean completed;

    NullRequestConsumer() {
    }

    @Override
    public void requestReceived(HttpRequest request) {
    }

    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioControl) throws IOException {
        int lastRead;
        do {
            this.buffer.clear();
        } while ((lastRead = decoder.read(this.buffer)) > 0);
    }

    @Override
    public void requestCompleted(HttpContext context) {
        this.completed = true;
    }

    @Override
    public void failed(Exception ex) {
        this.completed = true;
    }

    @Override
    public Object getResult() {
        return this.completed;
    }

    @Override
    public Exception getException() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.completed = true;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }
}

