/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.pool;

import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseFactory;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.config.ConnectionConfig;
import dark.org.http.impl.DefaultHttpResponseFactory;
import dark.org.http.impl.nio.DefaultNHttpClientConnectionFactory;
import dark.org.http.impl.nio.SSLNHttpClientConnectionFactory;
import dark.org.http.nio.NHttpClientConnection;
import dark.org.http.nio.NHttpConnectionFactory;
import dark.org.http.nio.NHttpMessageParserFactory;
import dark.org.http.nio.NHttpMessageWriterFactory;
import dark.org.http.nio.pool.NIOConnFactory;
import dark.org.http.nio.reactor.IOSession;
import dark.org.http.nio.reactor.ssl.SSLSetupHandler;
import dark.org.http.nio.util.ByteBufferAllocator;
import dark.org.http.nio.util.HeapByteBufferAllocator;
import dark.org.http.params.HttpParams;
import dark.org.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslContext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslContext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslContext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslContext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslContext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

