/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.conn;

import dark.org.commons.logging.Log;
import dark.org.commons.logging.LogFactory;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.conn.routing.HttpRoute;
import dark.org.http.impl.nio.conn.CPoolEntry;
import dark.org.http.nio.NHttpClientConnection;
import dark.org.http.nio.conn.ManagedNHttpClientConnection;
import dark.org.http.nio.pool.AbstractNIOConnPool;
import dark.org.http.nio.pool.NIOConnFactory;
import dark.org.http.nio.pool.SocketAddressResolver;
import dark.org.http.nio.reactor.ConnectingIOReactor;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractNIOConnPool<HttpRoute, ManagedNHttpClientConnection, CPoolEntry> {
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnectingIOReactor ioreactor, NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> connFactory, SocketAddressResolver<HttpRoute> addressResolver, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(ioreactor, connFactory, addressResolver, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedNHttpClientConnection conn) {
        CPoolEntry entry = new CPoolEntry(this.log, conn.getId(), route, conn, this.timeToLive, this.tunit);
        entry.setSocketTimeout(conn.getSocketTimeout());
        return entry;
    }

    @Override
    protected void onLease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(entry.getSocketTimeout());
    }

    @Override
    protected void onRelease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(0);
    }
}

