/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.codecs;

import dark.org.http.HttpRequest;
import dark.org.http.HttpRequestFactory;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.config.MessageConstraints;
import dark.org.http.impl.DefaultHttpRequestFactory;
import dark.org.http.impl.nio.codecs.DefaultHttpRequestParser;
import dark.org.http.message.BasicLineParser;
import dark.org.http.message.LineParser;
import dark.org.http.nio.NHttpMessageParser;
import dark.org.http.nio.NHttpMessageParserFactory;
import dark.org.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

