/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio.client;

import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.HttpResponse;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.client.ClientProtocolException;
import dark.org.http.client.methods.HttpUriRequest;
import dark.org.http.client.protocol.HttpClientContext;
import dark.org.http.client.utils.URIUtils;
import dark.org.http.concurrent.BasicFuture;
import dark.org.http.concurrent.FutureCallback;
import dark.org.http.nio.client.HttpAsyncClient;
import dark.org.http.nio.client.methods.HttpAsyncMethods;
import dark.org.http.nio.protocol.HttpAsyncRequestProducer;
import dark.org.http.nio.protocol.HttpAsyncResponseConsumer;
import dark.org.http.protocol.HttpContext;
import dark.org.http.util.Args;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

