/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.nio;

import dark.org.http.HttpHost;
import dark.org.http.HttpRequest;
import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseFactory;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.config.ConnectionConfig;
import dark.org.http.entity.ContentLengthStrategy;
import dark.org.http.impl.ConnSupport;
import dark.org.http.impl.DefaultHttpResponseFactory;
import dark.org.http.impl.nio.DefaultNHttpClientConnection;
import dark.org.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import dark.org.http.nio.NHttpConnectionFactory;
import dark.org.http.nio.NHttpMessageParserFactory;
import dark.org.http.nio.NHttpMessageWriterFactory;
import dark.org.http.nio.reactor.IOSession;
import dark.org.http.nio.reactor.ssl.SSLIOSession;
import dark.org.http.nio.reactor.ssl.SSLMode;
import dark.org.http.nio.reactor.ssl.SSLSetupHandler;
import dark.org.http.nio.util.ByteBufferAllocator;
import dark.org.http.nio.util.HeapByteBufferAllocator;
import dark.org.http.params.HttpParamConfig;
import dark.org.http.params.HttpParams;
import dark.org.http.ssl.SSLContexts;
import dark.org.http.util.Args;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class SSLNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    public static final SSLNHttpClientConnectionFactory INSTANCE = new SSLNHttpClientConnectionFactory();
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslContext;
    private final SSLSetupHandler sslHandler;
    private final ConnectionConfig cconfig;

    @Deprecated
    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(responseFactory, "HTTP response factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.sslContext = sslContext != null ? sslContext : SSLContexts.createSystemDefault();
        this.sslHandler = sslHandler;
        this.allocator = allocator;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(null, responseFactory);
        this.requestWriterFactory = null;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslContext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public SSLNHttpClientConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.sslContext = sslContext != null ? sslContext : SSLContexts.createSystemDefault();
        this.sslHandler = sslHandler;
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.responseParserFactory = responseParserFactory;
        this.requestWriterFactory = requestWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this(sslContext, sslHandler, null, null, responseParserFactory, requestWriterFactory, allocator, cconfig);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ConnectionConfig cconfig) {
        this(sslContext, sslHandler, null, null, responseParserFactory, requestWriterFactory, null, cconfig);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslContext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslContext, sslHandler, null, null, null, null, null, config);
    }

    public SSLNHttpClientConnectionFactory(ConnectionConfig config) {
        this(null, null, null, null, null, null, null, config);
    }

    public SSLNHttpClientConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    protected SSLIOSession createSSLIOSession(IOSession ioSession, SSLContext sslContext, SSLSetupHandler sslHandler) {
        Object attachment = ioSession.getAttribute("http.session.attachment");
        return new SSLIOSession(ioSession, SSLMode.CLIENT, attachment instanceof HttpHost ? (HttpHost)attachment : null, sslContext, sslHandler);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession ioSession) {
        SSLIOSession sslioSession = this.createSSLIOSession(ioSession, this.sslContext, this.sslHandler);
        ioSession.setAttribute("http.session.ssl", sslioSession);
        return new DefaultNHttpClientConnection(sslioSession, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

