/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl.entity;

import dark.org.http.HttpEntity;
import dark.org.http.HttpException;
import dark.org.http.HttpMessage;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.entity.ContentLengthStrategy;
import dark.org.http.impl.io.ChunkedOutputStream;
import dark.org.http.impl.io.ContentLengthOutputStream;
import dark.org.http.impl.io.IdentityOutputStream;
import dark.org.http.io.SessionOutputBuffer;
import dark.org.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outStream = this.doSerialize(outbuffer, message);
        entity.writeTo(outStream);
        outStream.close();
    }
}

