/*
 * Decompiled with CFR 0.152.
 */
package dark.org.http.impl;

import dark.org.http.HttpResponse;
import dark.org.http.HttpResponseFactory;
import dark.org.http.ProtocolVersion;
import dark.org.http.ReasonPhraseCatalog;
import dark.org.http.StatusLine;
import dark.org.http.annotation.Contract;
import dark.org.http.annotation.ThreadingBehavior;
import dark.org.http.impl.EnglishReasonPhraseCatalog;
import dark.org.http.message.BasicHttpResponse;
import dark.org.http.message.BasicStatusLine;
import dark.org.http.protocol.HttpContext;
import dark.org.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

