/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class RemoveEntitiesMessage {
    RegistryKey<World> worldRegistryKey;
    ResourceLocation rl;
    ChunkPos pos;
    boolean tile;
    boolean force;

    public RemoveEntitiesMessage(RegistryKey<World> worldRegistryKey, ResourceLocation rl, ChunkPos pos, boolean tile, boolean force) {
        this.worldRegistryKey = worldRegistryKey;
        this.rl = rl;
        this.pos = pos;
        this.tile = tile;
        this.force = force;
    }

    public static void encode(RemoveEntitiesMessage data, PacketBuffer buf) {
        NetworkTools.writeWorldKey(data.worldRegistryKey, buf);
        buf.func_192572_a(data.rl);
        buf.writeBoolean(data.tile);
        buf.writeBoolean(data.force);
        if (data.pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(data.pos.func_201841_a());
        }
    }

    public static RemoveEntitiesMessage decode(PacketBuffer buf) {
        RegistryKey<World> world = NetworkTools.readWorldKey(buf);
        ResourceLocation rl = buf.func_192575_l();
        boolean tile = buf.readBoolean();
        boolean force = buf.readBoolean();
        ChunkPos pos = null;
        if (buf.readBoolean()) {
            pos = new ChunkPos(buf.readLong());
        }
        return new RemoveEntitiesMessage(world, rl, pos, tile, force);
    }

    public static boolean handle(RemoveEntitiesMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.func_211513_k(2)) {
                return;
            }
            ServerWorld world = player.func_184102_h().func_71218_a(data.worldRegistryKey);
            if (data.pos == null) {
                if (data.tile) {
                    WorldUtils.removeTileEntityType((World)world, data.rl, data.force);
                } else {
                    WorldUtils.removeEntityType((World)world, data.rl, data.force);
                }
            } else if (data.tile) {
                WorldUtils.removeTileEntitiesInChunk((World)world, data.pos, data.rl, data.force);
            } else {
                WorldUtils.removeEntitiesInChunk((World)world, data.pos, data.rl, data.force);
            }
        });
        return true;
    }
}

