/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.ClientEvents;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenPlayerInvMessage {
    Map<String, Integer> slotAmounts;
    String otherPlayerName;
    int windowID;

    public OpenPlayerInvMessage(int id, String playerName, Map<String, Integer> curios) {
        this.windowID = id;
        this.otherPlayerName = playerName;
        this.slotAmounts = curios;
    }

    public static void encode(OpenPlayerInvMessage data, PacketBuffer buf) {
        buf.writeInt(data.windowID);
        buf.func_180714_a(data.otherPlayerName);
        buf.writeInt(data.slotAmounts.size());
        data.slotAmounts.forEach((s, i) -> {
            buf.func_180714_a(s);
            buf.writeInt(i.intValue());
        });
    }

    public static OpenPlayerInvMessage decode(PacketBuffer buf) {
        LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
        int id = buf.readInt();
        String name = buf.func_218666_n();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            curios.put(buf.func_218666_n(), buf.readInt());
        }
        return new OpenPlayerInvMessage(id, name, curios);
    }

    public static boolean handle(OpenPlayerInvMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEvents.openContainerAndScreen(data.windowID, data.otherPlayerName, data.slotAmounts));
        return true;
    }
}

