/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class NetworkTools {
    public static void writeSChPMap(PacketBuffer buf, Map<String, Set<ChunkPos>> map) {
        buf.writeInt(map.size());
        map.forEach((key, value) -> {
            buf.func_180714_a(key);
            buf.writeInt(value.size());
            value.forEach(x -> buf.writeLong(x.func_201841_a()));
        });
    }

    public static Map<String, Set<ChunkPos>> readSChPMap(PacketBuffer buf) {
        HashMap<String, Set<ChunkPos>> map = new HashMap<String, Set<ChunkPos>>();
        int mapsize = buf.readInt();
        for (int i = 0; i < mapsize; ++i) {
            String key = buf.func_218666_n();
            int listsize = buf.readInt();
            HashSet<ChunkPos> list = new HashSet<ChunkPos>();
            for (int j = 0; j < listsize; ++j) {
                list.add(new ChunkPos(buf.readLong()));
            }
            map.put(key, list);
        }
        return map;
    }

    public static void writeWorldKey(RegistryKey<World> worldKey, PacketBuffer buf) {
        ResourceLocation loc = worldKey.func_240901_a_();
        buf.func_192572_a(loc);
    }

    public static RegistryKey<World> readWorldKey(PacketBuffer buf) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
    }

    public static void writeWorldPos(WorldPos pos, PacketBuffer buf) {
        buf.func_179255_a(pos.pos);
        NetworkTools.writeWorldKey(pos.type, buf);
        buf.func_179252_a(pos.id);
    }

    public static WorldPos readWorldPos(PacketBuffer buf) {
        return new WorldPos(buf.func_179259_c(), NetworkTools.readWorldKey(buf), buf.func_179253_g());
    }

    public static void writeRLWPMap(Map<ResourceLocation, List<WorldPos>> map, PacketBuffer buf) {
        buf.writeInt(map.size());
        map.forEach((x, y) -> {
            buf.func_192572_a(x);
            buf.writeInt(y.size());
            y.forEach(e -> NetworkTools.writeWorldPos(e, buf));
        });
    }

    public static Map<ResourceLocation, List<WorldPos>> readRLWPMap(PacketBuffer buf) {
        HashMap<ResourceLocation, List<WorldPos>> map = new HashMap<ResourceLocation, List<WorldPos>>();
        int mapsize = buf.readInt();
        for (int i = 0; i < mapsize; ++i) {
            ResourceLocation loc = buf.func_192575_l();
            int listsize = buf.readInt();
            ArrayList<WorldPos> list = new ArrayList<WorldPos>();
            for (int j = 0; j < listsize; ++j) {
                list.add(NetworkTools.readWorldPos(buf));
            }
            map.put(loc, list);
        }
        return map;
    }

    public static boolean returnOnNull(Object ... objects) {
        return Arrays.stream(objects).anyMatch(Objects::isNull);
    }
}

