/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.EntityCommands;

import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class RemoveEntitiesCommand {
    private static final SuggestionProvider<CommandSource> sugg = (ctx, builder) -> ISuggestionProvider.func_212476_a(ForgeRegistries.ENTITIES.getKeys().stream(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSource> boolsugg = (ctx, builder) -> ISuggestionProvider.func_197005_b(Collections.singletonList("force"), (SuggestionsBuilder)builder);
    private static int counter = 0;

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSource>)ctx, null))).then(Commands.func_197057_a((String)"byType").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(sugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSource>)ctx, ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"type")))).then(Commands.func_197056_a((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSource>)ctx, ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"type"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"items").executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSource>)ctx, null))).then(Commands.func_197056_a((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSource>)ctx, null)))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.func_197056_a((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hostile").executes(RemoveEntitiesCommand::removeMonsters)).then(Commands.func_197056_a((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(RemoveEntitiesCommand::removeMonsters)))).then(Commands.func_197057_a((String)"regex").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"regex", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex")))).then(Commands.func_197056_a((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex"))))));
    }

    private static int removeEntities(CommandContext<CommandSource> context, ResourceLocation type) {
        counter = 0;
        List<ServerWorld> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().filter(entity -> {
            if (type == null) {
                return !entity.func_145818_k_();
            }
            if (entity.func_200600_R().getRegistryName() != null) {
                return entity.func_200600_R().getRegistryName().equals((Object)type);
            }
            return false;
        }).forEach(x -> RemoveEntitiesCommand.removeEntity(context, world, x)));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeEntitiesByRegEx(CommandContext<CommandSource> context, String regex) {
        counter = 0;
        List<ServerWorld> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().filter(entity -> {
            if (regex == null) {
                return !entity.func_145818_k_();
            }
            if (entity != null && entity.func_200600_R().getRegistryName() != null) {
                return entity.func_200600_R().getRegistryName().toString().matches(regex);
            }
            return false;
        }).forEach(x -> RemoveEntitiesCommand.removeEntity(context, world, x)));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeItems(CommandContext<CommandSource> context, String type) {
        counter = 0;
        List<ServerWorld> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().filter(x -> x instanceof ItemEntity).map(x -> (ItemEntity)x).filter(x -> type == null ? !x.func_145818_k_() : x.func_200200_C_().getString().contains(type)).forEach(x -> RemoveEntitiesCommand.removeEntity(context, world, (Entity)x)));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeMonsters(CommandContext<CommandSource> context) {
        counter = 0;
        List<ServerWorld> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().filter(x -> x.func_200600_R().func_220339_d() == EntityClassification.MONSTER).forEach(x -> RemoveEntitiesCommand.removeEntity(context, world, x)));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static void removeEntity(CommandContext<CommandSource> context, ServerWorld world, Entity x) {
        boolean force = false;
        try {
            String forced = StringArgumentType.getString(context, (String)"force");
            force = forced.equals("force");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (force) {
            world.removeEntityComplete(x, false);
        } else {
            x.func_70106_y();
        }
        ++counter;
    }

    private static void respond(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Removed " + counter + " Entities"), true);
    }
}

