/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.blay09.mods.craftingtweaks.client.KeyBindings;
import net.blay09.mods.craftingtweaks.net.MessageBalance;
import net.blay09.mods.craftingtweaks.net.MessageClear;
import net.blay09.mods.craftingtweaks.net.MessageCompress;
import net.blay09.mods.craftingtweaks.net.MessageCraftStack;
import net.blay09.mods.craftingtweaks.net.MessageRotate;
import net.blay09.mods.craftingtweaks.net.MessageTransferStack;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CraftingTweaksClient {
    private final ClientProvider clientProvider = new ClientProvider();
    private boolean ignoreMouseUp;
    private int rightClickCraftingSlot = -1;
    private int guiLeftOnMistakeFix;

    @SubscribeEvent
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (container == null) {
            return;
        }
        Screen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (!(guiScreen instanceof ContainerScreen)) {
            return;
        }
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
        InputMappings.Input input = InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode());
        CompressType compressType = KeyBindings.getCompressTypeForKey(input);
        if (provider != null && provider.isValidContainer(container)) {
            CraftingTweaksMode config = CraftingTweaksConfig.getCraftingTweaksMode(provider.getModId());
            if (config == CraftingTweaksMode.DEFAULT || config == CraftingTweaksMode.HOTKEYS) {
                boolean isRotate = KeyBindings.keyRotate.isActiveAndMatches(input);
                boolean isRotateCCW = KeyBindings.keyRotateCounterClockwise.isActiveAndMatches(input);
                boolean isBalance = KeyBindings.keyBalance.isActiveAndMatches(input);
                boolean isSpread = KeyBindings.keySpread.isActiveAndMatches(input);
                boolean isClear = KeyBindings.keyClear.isActiveAndMatches(input);
                boolean isForceClear = KeyBindings.keyForceClear.isActiveAndMatches(input);
                boolean isRefill = KeyBindings.keyRefillLast.isActiveAndMatches(input);
                boolean isRefillStack = KeyBindings.keyRefillLastStack.isActiveAndMatches(input);
                if (isRotate || isRotateCCW) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.channel.sendToServer((Object)new MessageRotate(0, isRotateCCW));
                    } else {
                        this.clientProvider.rotateGrid(provider, (PlayerEntity)player, container, 0, isRotateCCW);
                    }
                    event.setCanceled(true);
                } else if (isClear || isForceClear) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.channel.sendToServer((Object)new MessageClear(0, isForceClear));
                    } else {
                        this.clientProvider.clearGrid(provider, (PlayerEntity)player, container, 0, isForceClear);
                    }
                    event.setCanceled(true);
                } else if (isBalance || isSpread) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.channel.sendToServer((Object)new MessageBalance(0, isSpread));
                    } else if (isSpread) {
                        this.clientProvider.spreadGrid(provider, (PlayerEntity)player, container, 0);
                    } else {
                        this.clientProvider.balanceGrid(provider, (PlayerEntity)player, container, 0);
                    }
                    event.setCanceled(true);
                } else if (isRefill || isRefillStack) {
                    this.clientProvider.refillLastCrafted(provider, (PlayerEntity)player, container, 0, isRefillStack);
                    event.setCanceled(true);
                }
            }
            ContainerScreen guiContainer = (ContainerScreen)guiScreen;
            if (compressType != null) {
                Slot mouseSlot = guiContainer.getSlotUnderMouse();
                if (mouseSlot != null) {
                    if (CraftingTweaks.isServerSideInstalled) {
                        NetworkHandler.channel.sendToServer((Object)new MessageCompress(mouseSlot.field_75222_d, compressType));
                    } else {
                        this.clientProvider.compress(provider, player, container, mouseSlot, compressType);
                    }
                    event.setCanceled(true);
                }
            } else if (KeyBindings.keyToggleButtons.isActiveAndMatches(input)) {
                CraftingTweaksConfig.setHideButtons((Boolean)CraftingTweaksConfig.CLIENT.hideButtons.get() == false);
                Minecraft mc = Minecraft.func_71410_x();
                guiScreen.func_231158_b_(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
                event.setCanceled(true);
            }
        } else if (CraftingTweaks.isServerSideInstalled) {
            ContainerScreen guiContainer = (ContainerScreen)guiScreen;
            if (compressType != null) {
                Slot mouseSlot = guiContainer.getSlotUnderMouse();
                if (mouseSlot != null) {
                    NetworkHandler.channel.sendToServer((Object)new MessageCompress(mouseSlot.field_75222_d, compressType));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        if (this.ignoreMouseUp) {
            event.setCanceled(true);
            this.ignoreMouseUp = false;
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        this.rightClickCraftingSlot = -1;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Container container = player.field_71070_bA;
        if (container == null) {
            return;
        }
        Slot mouseSlot = event.getGui() instanceof ContainerScreen ? ((ContainerScreen)event.getGui()).getSlotUnderMouse() : null;
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
        if (provider != null && provider.isValidContainer(container)) {
            if (KeyBindings.isActiveIgnoreContext(KeyBindings.keyTransferStack)) {
                if (mouseSlot != null && mouseSlot.func_75216_d()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (Screen.func_231173_s_()) {
                        ItemStack mouseSlotStack = mouseSlot.func_75211_c();
                        for (Slot slot : container.field_75151_b) {
                            ItemStack slotStack;
                            if (!slot.func_75216_d() || mouseSlot == slot || !(slotStack = slot.func_75211_c()).func_77969_a(mouseSlotStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (Slot slot : transferSlots) {
                            NetworkHandler.channel.sendToServer((Object)new MessageTransferStack(0, slot.field_75222_d));
                        }
                    } else {
                        for (Slot slot : transferSlots) {
                            this.clientProvider.transferIntoGrid(provider, (PlayerEntity)player, container, 0, slot);
                        }
                        this.ignoreMouseUp = true;
                    }
                    event.setCanceled(true);
                }
            } else if (((Boolean)CraftingTweaksConfig.CLIENT.rightClickCraftsStack.get()).booleanValue() && event.getButton() == 1 && mouseSlot instanceof CraftingResultSlot) {
                if (CraftingTweaks.isServerSideInstalled) {
                    NetworkHandler.channel.sendToServer((Object)new MessageCraftStack(mouseSlot.field_75222_d));
                } else {
                    this.rightClickCraftingSlot = mouseSlot.field_75222_d;
                }
                event.setCanceled(true);
                this.ignoreMouseUp = true;
            }
        }
    }

    private <T extends Container> void initGui(ContainerScreen<T> guiContainer, GuiScreenEvent.InitGuiEvent event) {
        CraftingTweaksMode config;
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(guiContainer.func_212873_a_());
        if (provider != null && ((config = CraftingTweaksConfig.getCraftingTweaksMode(provider.getModId())) == CraftingTweaksMode.DEFAULT || config == CraftingTweaksMode.BUTTONS) && !((Boolean)CraftingTweaksConfig.CLIENT.hideButtons.get()).booleanValue() && provider.isValidContainer(guiContainer.func_212873_a_())) {
            provider.initGui(guiContainer, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInitGuiFirst(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen) {
            CraftingGuideButtonFixer.fixMistakes((ContainerScreen)event.getGui(), event.getWidgetList());
            this.guiLeftOnMistakeFix = ((ContainerScreen)event.getGui()).getGuiLeft();
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen) {
            this.initGui((ContainerScreen)event.getGui(), (GuiScreenEvent.InitGuiEvent)event);
        }
    }

    private void handleRightClickCrafting() {
        if (this.rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = this.rightClickCraftingSlot;
        this.rightClickCraftingSlot = -1;
        ClientPlayerEntity entityPlayer = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayer == null) {
            return;
        }
        PlayerController playerController = Minecraft.func_71410_x().field_71442_b;
        if (playerController == null) {
            return;
        }
        Container container = entityPlayer.field_71070_bA;
        if (container == null) {
            return;
        }
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
        if (provider == null || !provider.isValidContainer(container)) {
            return;
        }
        if (craftingSlot >= container.field_75151_b.size()) {
            return;
        }
        Slot mouseSlot = (Slot)container.field_75151_b.get(craftingSlot);
        if (!mouseSlot.func_75216_d()) {
            this.rightClickCraftingSlot = mouseSlot.field_75222_d;
            return;
        }
        ItemStack mouseStack = entityPlayer.field_71071_by.func_70445_o();
        if (mouseStack.func_190926_b() || mouseStack.func_190916_E() + mouseSlot.func_75211_c().func_190916_E() <= mouseStack.func_77976_d()) {
            playerController.func_187098_a(container.field_75152_c, mouseSlot.field_75222_d, 0, ClickType.PICKUP, (PlayerEntity)entityPlayer);
            this.rightClickCraftingSlot = mouseSlot.field_75222_d;
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        ContainerScreen containerScreen;
        int guiLeft;
        if (event.getGui() == null) {
            return;
        }
        if (event.getGui() instanceof ContainerScreen && (guiLeft = (containerScreen = (ContainerScreen)event.getGui()).getGuiLeft()) != this.guiLeftOnMistakeFix) {
            CraftingGuideButtonFixer.fixMistakes(containerScreen, containerScreen.func_231039_at__());
            this.guiLeftOnMistakeFix = guiLeft;
        }
        this.handleRightClickCrafting();
        if (!((Boolean)CraftingTweaksConfig.CLIENT.hideButtonTooltips.get()).booleanValue()) {
            List<Object> tooltipList = Collections.emptyList();
            for (IGuiEventListener button : event.getGui().func_231039_at__()) {
                if (!(button instanceof ITooltipProvider) || !button.func_231047_b_((double)event.getMouseX(), (double)event.getMouseY())) continue;
                tooltipList = ((ITooltipProvider)button).getTooltip();
                break;
            }
            if (!tooltipList.isEmpty()) {
                event.getGui().func_243308_b(event.getMatrixStack(), tooltipList, event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        this.clientProvider.onItemCrafted(event.getInventory());
    }

    public ClientProvider getClientProvider() {
        return this.clientProvider;
    }
}

