/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.blay09.mods.craftingtweaks.CraftingTweaksMode;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="craftingtweaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CraftingTweaksConfig {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    private static ModConfig clientConfig;

    public static void setHideButtons(boolean hideButtons) {
        CraftingTweaksConfig.CLIENT.hideButtons.set((Object)hideButtons);
        clientConfig.save();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            clientConfig = event.getConfig();
        }
    }

    public static CraftingTweaksMode getCraftingTweaksMode(String modId) {
        if (((List)CraftingTweaksConfig.CLIENT.disabledAddons.get()).contains(modId)) {
            return CraftingTweaksMode.DISABLED;
        }
        return (CraftingTweaksMode)((Object)CraftingTweaksConfig.CLIENT.craftingTweaksMode.get());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue hideButtons;
        public final ForgeConfigSpec.BooleanValue rightClickCraftsStack;
        public final ForgeConfigSpec.BooleanValue hideButtonTooltips;
        public final ForgeConfigSpec.BooleanValue hideVanillaCraftingGuide;
        public final ForgeConfigSpec.EnumValue<CraftingTweaksMode> craftingTweaksMode;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledAddons;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Crafting Tweaks Client Configuration").push("client");
            this.hideButtons = builder.comment("This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.").translation("craftingtweaks.config.hideButtons").define("hideButtons", false);
            this.hideVanillaCraftingGuide = builder.comment("We both know JEI is much better. This option hides Vanilla's crafting book button instead of moving it.").translation("craftingtweaks.config.hideVanillaCraftingGuide").define("hideVanillaCraftingGuide", false);
            this.rightClickCraftsStack = builder.comment("If set to true, right-clicking the result slot in a crafting table will craft a full stack.").translation("craftingtweaks.config.rightClickCraftsStack").define("rightClickCraftsStack", true);
            this.hideButtonTooltips = builder.comment("Set this to true if you don't want the tweak buttons' tooltips to show.").translation("craftingtweaks.config.hideButtonTooltips").define("hideButtonTooltips", false);
            this.craftingTweaksMode = builder.comment("Set to 'DEFAULT' to enable both buttons and hotkeys. Set to 'BUTTONS' to enable buttons only. Set to 'HOTKEYS' to enable hotkeys only.").translation("craftingtweaks.config.craftingTweaksMode").defineEnum("craftingTweaksMode", (Enum)CraftingTweaksMode.DEFAULT);
            this.disabledAddons = builder.comment("Add modids here of mods that you wish to disable Crafting Tweaks support for.").translation("craftingtweaks.config.disabledAddons").defineList("disabledAddons", ArrayList::new, it -> it instanceof String);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue compressAnywhere;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> compressBlacklist;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Crafting Tweaks Configuration").push("common");
            this.compressAnywhere = builder.comment("Set this to true if you want the (de)compress feature to work outside of crafting GUIs (only works if installed on server)").translation("craftingtweaks.config.compressAnywhere").define("compressAnywhere", false);
            this.compressBlacklist = builder.comment("A list of modid:name entries that will not be crafted by the compress key.").translation("craftingtweaks.config.compressBlacklist").defineList("compressBlacklist", Arrays.asList("minecraft:sandstone", "minecraft:iron_trapdoor"), it -> it instanceof String);
        }
    }
}

