/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.Compatibility;
import net.blay09.mods.craftingtweaks.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.InternalMethodsImpl;
import net.blay09.mods.craftingtweaks.SimpleTweakProviderImpl;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClient;
import net.blay09.mods.craftingtweaks.client.KeyBindings;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="craftingtweaks")
public class CraftingTweaks {
    public static boolean TEST_CLIENT_SIDE = false;
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "craftingtweaks";
    public static boolean isServerSideInstalled;
    public static Optional<CraftingTweaksClient> craftingTweaksClient;

    public CraftingTweaks() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processInterMod);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CraftingTweaksConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CraftingTweaksConfig.clientSpec);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        CraftingTweaksAPI.setupAPI(new InternalMethodsImpl());
    }

    private void processInterMod(InterModProcessEvent event) {
        event.getIMCStream(it -> it.equals("RegisterProvider") || it.equals("RegisterProviderV2") || it.equals("RegisterProviderV3")).forEach(message -> {
            String getGridStartFunction;
            String validContainerPredicate;
            CompoundNBT tagCompound = (CompoundNBT)message.getMessageSupplier().get();
            String sender = message.getSenderModId();
            String containerClassName = tagCompound.func_74779_i("ContainerClass");
            SimpleTweakProviderImpl provider = new SimpleTweakProviderImpl(sender);
            int buttonOffsetX = tagCompound.func_74764_b("ButtonOffsetX") ? tagCompound.func_74762_e("ButtonOffsetX") : -16;
            int buttonOffsetY = tagCompound.func_74764_b("ButtonOffsetY") ? tagCompound.func_74762_e("ButtonOffsetY") : 16;
            Direction alignToGrid = null;
            String alignToGridName = tagCompound.func_74779_i("AlignToGrid");
            switch (alignToGridName.toLowerCase()) {
                case "north": 
                case "up": {
                    alignToGrid = Direction.UP;
                    break;
                }
                case "south": 
                case "down": {
                    alignToGrid = Direction.DOWN;
                    break;
                }
                case "east": 
                case "right": {
                    alignToGrid = Direction.EAST;
                    break;
                }
                case "west": 
                case "left": {
                    alignToGrid = Direction.WEST;
                }
            }
            provider.setAlignToGrid(alignToGrid);
            provider.setGrid(CraftingTweaks.getIntOr(tagCompound, "GridSlotNumber", 1), CraftingTweaks.getIntOr(tagCompound, "GridSize", 9));
            provider.setHideButtons(tagCompound.func_74767_n("HideButtons"));
            provider.setPhantomItems(tagCompound.func_74767_n("PhantomItems"));
            CompoundNBT rotateCompound = tagCompound.func_74775_l("TweakRotate");
            provider.setTweakRotate(CraftingTweaks.getBoolOr(rotateCompound, "Enabled", true), CraftingTweaks.getBoolOr(rotateCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(rotateCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(rotateCompound, "ButtonY", 0));
            CompoundNBT balanceCompound = tagCompound.func_74775_l("TweakBalance");
            provider.setTweakBalance(CraftingTweaks.getBoolOr(balanceCompound, "Enabled", true), CraftingTweaks.getBoolOr(balanceCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(balanceCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(balanceCompound, "ButtonY", 18));
            CompoundNBT clearCompound = tagCompound.func_74775_l("TweakClear");
            provider.setTweakClear(CraftingTweaks.getBoolOr(clearCompound, "Enabled", true), CraftingTweaks.getBoolOr(clearCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(clearCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(clearCompound, "ButtonY", 36));
            String validContainerPredicateLegacy = tagCompound.func_74779_i("ContainerCallback");
            if (!validContainerPredicateLegacy.isEmpty()) {
                try {
                    Class<?> functionClass = Class.forName(validContainerPredicateLegacy);
                    if (!Function.class.isAssignableFrom(functionClass)) {
                        logger.error("{} sent a container callback that's not even a function", (Object)sender);
                        return;
                    }
                    final Function function = (Function)functionClass.newInstance();
                    provider.setContainerValidPredicate(new Predicate<Container>(){

                        @Override
                        public boolean test(@Nullable Container input) {
                            Boolean result = (Boolean)function.apply(input);
                            return result != null ? result : false;
                        }
                    });
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("{} sent an invalid container callback.", (Object)sender);
                }
            }
            if (!(validContainerPredicate = tagCompound.func_74779_i("ValidContainerPredicate")).isEmpty()) {
                try {
                    Class<?> predicateClass = Class.forName(validContainerPredicate);
                    if (!Predicate.class.isAssignableFrom(predicateClass)) {
                        logger.error("{} sent an invalid ValidContainerPredicate - it must implement Predicate<Container>", (Object)sender);
                        return;
                    }
                    Predicate predicate = (Predicate)predicateClass.newInstance();
                    provider.setContainerValidPredicate(predicate);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("{} sent an invalid ValidContainerPredicate: {}", (Object)sender, (Object)e.getMessage());
                }
            }
            if (!(getGridStartFunction = tagCompound.func_74779_i("GetGridStartFunction")).isEmpty()) {
                try {
                    Class<?> functionClass = Class.forName(getGridStartFunction);
                    if (!Function.class.isAssignableFrom(functionClass)) {
                        logger.error("{} sent an invalid GetGridStartFunction - it must implement Function<Container, Integer>", (Object)sender);
                        return;
                    }
                    Function function = (Function)functionClass.newInstance();
                    provider.setGetGridStartFunction(function);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("{} sent an invalid GetGridStartFunction: {}", (Object)sender, (Object)e.getMessage());
                }
            }
            CraftingTweaksProviderManager.registerProvider(containerClassName, provider);
            logger.info("{} has registered {} for CraftingTweaks", (Object)sender, (Object)containerClassName);
        });
    }

    private void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(NetworkHandler::init);
        Compatibility.vanilla();
    }

    private void setupClient(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            craftingTweaksClient = Optional.of(new CraftingTweaksClient());
            DeferredWorkQueue.runLater(() -> {
                KeyBindings.init();
                craftingTweaksClient.ifPresent(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0));
            });
        });
    }

    private static int getIntOr(CompoundNBT tagCompound, String key, int defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74762_e(key) : defaultVal;
    }

    private static boolean getBoolOr(CompoundNBT tagCompound, String key, boolean defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74767_n(key) : defaultVal;
    }

    static {
        craftingTweaksClient = Optional.empty();
    }
}

