/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.tfar.craftingstation.Configs;
import com.tfar.craftingstation.CraftingInventoryPersistant;
import com.tfar.craftingstation.CraftingStation;
import com.tfar.craftingstation.CraftingStationBlockEntity;
import com.tfar.craftingstation.network.PacketHandler;
import com.tfar.craftingstation.network.S2CLastRecipePacket;
import com.tfar.craftingstation.slot.BigSlot;
import com.tfar.craftingstation.slot.SlotFastCraft;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationContainer
extends Container {
    private static final Method GET_TILE_ENTITY_METHOD;
    public final CraftingInventoryPersistant craftMatrix;
    public final CraftResultInventory craftResult = new CraftResultInventory();
    public final World world;
    public final CraftingStationBlockEntity tileEntity;
    public final List<Pair<Integer, Integer>> containerStarts = new ArrayList<Pair<Integer, Integer>>();
    public final List<ItemStack> blocks = new ArrayList<ItemStack>();
    public final List<ITextComponent> containerNames = new ArrayList<ITextComponent>();
    private final PlayerEntity player;
    public IRecipe<CraftingInventory> lastRecipe;
    public int subContainerSize = 0;
    public boolean hasSideContainers;
    public int currentContainer;
    protected IRecipe<CraftingInventory> lastLastRecipe;

    private static TileEntity getTileEntityAtPos(BlockPos pos, World world) {
        try {
            return GET_TILE_ENTITY_METHOD != null ? (TileEntity)GET_TILE_ENTITY_METHOD.invoke(null, pos, world) : world.func_175625_s(pos);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return world.func_175625_s(pos);
        }
    }

    public CraftingStationContainer(int id, PlayerInventory inv, World world, BlockPos pos) {
        super(CraftingStation.Objects.crafting_station_container, id);
        this.world = world;
        this.player = inv.field_70458_d;
        this.tileEntity = (CraftingStationBlockEntity)CraftingStationContainer.getTileEntityAtPos(pos, world);
        this.currentContainer = this.tileEntity.currentContainer;
        this.craftMatrix = new CraftingInventoryPersistant(this, this.tileEntity.input);
        this.hasSideContainers = false;
        this.addOwnSlots();
        if (((Boolean)Configs.Server.sideInventories.get()).booleanValue()) {
            this.searchSideInventories(pos);
        }
        this.addPlayerSlots(inv);
        this.func_75130_a((IInventory)this.craftMatrix);
        if (this.hasSideContainers) {
            this.changeContainer(this.currentContainer);
        }
    }

    protected void searchSideInventories(BlockPos pos) {
        Direction accessDir = null;
        ArrayList<TileEntity> tileEntities = new ArrayList<TileEntity>();
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = pos.func_177972_a(dir);
            TileEntity te = this.world.func_175625_s(neighbor);
            if (te == null || te instanceof CraftingStationBlockEntity || CraftingStation.blacklisted.func_230235_a_((Object)te.func_200662_C()) || te instanceof IInventory && !((IInventory)te).func_70300_a(this.player) || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).filter(IItemHandlerModifiable.class::isInstance).isPresent()) continue;
            tileEntities.add(te);
            this.blocks.add(new ItemStack((IItemProvider)this.world.func_180495_p(neighbor).func_177230_c()));
        }
        if (!tileEntities.isEmpty()) {
            for (TileEntity tileEntity : tileEntities) {
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(this::accept);
            }
        }
        if (!tileEntities.isEmpty()) {
            this.addSideContainerSlots(tileEntities, accessDir, -125, 17);
        }
    }

    public static IRecipe<CraftingInventory> findRecipe(CraftingInventory inv, World world, PlayerEntity player) {
        return world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values().stream().flatMap(recipe -> {
            try {
                return Util.func_215081_a((Optional)IRecipeType.field_222149_a.func_222148_a(recipe, world, (IInventory)inv));
            }
            catch (Exception e) {
                CraftingStation.LOGGER.error("Bad recipe found: " + recipe.func_199560_c().toString());
                CraftingStation.LOGGER.error(e.getMessage());
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.crafting_station.error", new Object[]{recipe.func_199560_c().toString()}).func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
                return null;
            }
        }).findFirst().orElse(null);
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotFastCraft(this, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35, this.player));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + 3 * y, 30 + 18 * x, 17 + 18 * y));
            }
        }
    }

    private void addSideContainerSlots(List<TileEntity> tes, Direction dir, int xPos, int yPos) {
        int i = 0;
        while (i < tes.size()) {
            TileEntity te = tes.get(i);
            this.containerNames.add((ITextComponent)(te instanceof INamedContainerProvider ? ((INamedContainerProvider)te).func_145748_c_() : new TranslationTextComponent(te.func_195044_w().func_177230_c().func_149739_a())));
            int number = i++;
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                int size = h.getSlots();
                this.subContainerSize += size;
                int offsetx = this.needsScroll() ? 0 : 8;
                for (int y = 0; y < (int)Math.ceil((double)size / 6.0); ++y) {
                    for (int x = 0; x < 6; ++x) {
                        int index = 6 * y + x;
                        if (index >= size) continue;
                        boolean hidden = y >= 9 || number != 0;
                        BigSlot wrapper = new BigSlot((IItemHandler)h, index, 18 * x + xPos + offsetx, 18 * y + yPos);
                        if (hidden) {
                            this.hideSlot((Slot)wrapper);
                        }
                        this.func_75146_a((Slot)wrapper);
                    }
                }
            });
        }
        this.hasSideContainers = true;
    }

    public void hideSlot(Slot slot) {
        slot.field_75221_f = Integer.MAX_VALUE;
    }

    public void func_75134_a(PlayerEntity player) {
        this.tileEntity.currentContainer = this.currentContainer;
        super.func_75134_a(player);
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + x + 9 * y, 8 + 18 * x, 84 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + 18 * x, 142));
        }
    }

    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.craftMatrix.setDoNotCallUpdates(true);
        super.func_190896_a(p_190896_1_);
        this.craftMatrix.setDoNotCallUpdates(false);
        this.craftMatrix.onCraftMatrixChanged();
    }

    public void func_75130_a(IInventory inventory) {
        this.slotChangedCraftingGrid(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        boolean nothingDone;
        if (this.hasSideContainers) {
            return this.handleTransferWithSides(playerIn, index);
        }
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = slot.func_75211_c().func_77946_l();
        ItemStack stack = slot.func_75211_c().func_77946_l();
        if (index == 0) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else if (index < 10) {
            nothingDone = !this.moveToPlayerInventory(stack);
        } else {
            boolean bl = nothingDone = !this.moveToCraftingStation(stack);
        }
        if (nothingDone) {
            return ItemStack.field_190927_a;
        }
        return this.notifySlotAfterTransfer(playerIn, stack, ret, slot);
    }

    protected ItemStack handleTransferWithSides(PlayerEntity player, int index) {
        boolean nothingDone;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = slot.func_75211_c().func_77946_l();
        ItemStack stack = ret.func_77946_l();
        if (index == 0) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.mergeItemStackMove(stack, 10, 10 + this.subContainerSize);
        } else if (index < 10) {
            nothingDone = !this.refillSideInventory(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else if (index < 10 + this.subContainerSize) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToPlayerInventory(stack);
        } else if (index >= 10 + this.subContainerSize) {
            nothingDone = !this.moveToCraftingStation(stack);
            nothingDone &= !this.moveToSideInventory(stack);
        } else {
            return ItemStack.field_190927_a;
        }
        if (nothingDone) {
            return ItemStack.field_190927_a;
        }
        return this.notifySlotAfterTransfer(player, stack, ret, slot);
    }

    protected void slotChangedCraftingGrid(World world, PlayerEntity player, CraftingInventory inv, CraftResultInventory result) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.lastRecipe == null || !this.lastRecipe.func_77569_a((IInventory)inv, world)) {
            this.lastRecipe = CraftingStationContainer.findRecipe(inv, world, player);
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.func_77572_b((IInventory)inv);
        }
        result.func_70299_a(0, itemstack);
        if (!world.field_72995_K) {
            ServerPlayerEntity entityplayermp = (ServerPlayerEntity)player;
            List<ServerPlayerEntity> relevantPlayers = this.getAllPlayersWithThisContainerOpen(this, entityplayermp.func_71121_q());
            this.syncResultToAllOpenWindows(itemstack, relevantPlayers);
            if (this.lastLastRecipe != this.lastRecipe) {
                this.syncRecipeToAllOpenWindows(this.lastRecipe, relevantPlayers);
                this.lastLastRecipe = this.lastRecipe;
            }
        }
    }

    private void syncResultToAllOpenWindows(ItemStack stack, List<ServerPlayerEntity> players) {
        players.forEach(otherPlayer -> otherPlayer.field_71070_bA.func_75141_a(0, stack));
    }

    private void syncRecipeToAllOpenWindows(IRecipe<CraftingInventory> lastRecipe, List<ServerPlayerEntity> players) {
        players.forEach(otherPlayer -> {
            ((CraftingStationContainer)otherPlayer.field_71070_bA).lastRecipe = lastRecipe;
            PacketHandler.INSTANCE.sendTo((Object)new S2CLastRecipePacket(lastRecipe), otherPlayer.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        });
    }

    private List<ServerPlayerEntity> getAllPlayersWithThisContainerOpen(CraftingStationContainer container, ServerWorld server) {
        return server.func_217369_A().stream().filter(player -> this.hasSameContainerOpen(container, (PlayerEntity)player)).collect(Collectors.toList());
    }

    private boolean hasSameContainerOpen(CraftingStationContainer container, PlayerEntity playerToCheck) {
        return playerToCheck instanceof ServerPlayerEntity && playerToCheck.field_71070_bA.getClass().isAssignableFrom(((Object)((Object)container)).getClass()) && this.sameGui((CraftingStationContainer)playerToCheck.field_71070_bA);
    }

    public boolean sameGui(CraftingStationContainer otherContainer) {
        return this.tileEntity == otherContainer.tileEntity;
    }

    @Nonnull
    protected ItemStack notifySlotAfterTransfer(PlayerEntity player, @Nonnull ItemStack stack, @Nonnull ItemStack original, Slot slot) {
        slot.func_75220_a(stack, original);
        if (stack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(stack);
        slot.func_190901_a(player, stack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    protected boolean moveToSideInventory(@Nonnull ItemStack itemstack) {
        return this.hasSideContainers && this.mergeItemStackMove(itemstack, 10, 10 + this.subContainerSize);
    }

    protected boolean moveToPlayerInventory(@Nonnull ItemStack itemstack) {
        return this.func_75135_a(itemstack, 10 + this.subContainerSize, this.field_75151_b.size(), false);
    }

    protected boolean refillSideInventory(@Nonnull ItemStack itemStack) {
        return this.mergeItemStackRefill(itemStack, 10, 10 + this.subContainerSize);
    }

    protected boolean moveToCraftingStation(@Nonnull ItemStack itemstack) {
        return this.func_75135_a(itemstack, 1, 10, false);
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean didSomething = this.mergeItemStackRefill(stack, startIndex, endIndex);
        if (!stack.func_190926_b()) {
            didSomething |= this.mergeItemStackMove(stack, startIndex, endIndex);
        }
        return didSomething;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean didSomething = false;
        if (stack.func_77985_e()) {
            for (int k = startIndex; k < endIndex && !stack.func_190926_b(); ++k) {
                int limit;
                Slot targetSlot = (Slot)this.field_75151_b.get(k);
                ItemStack slotStack = targetSlot.func_75211_c();
                if (slotStack.func_190926_b() || slotStack.func_77973_b() != stack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack) || !this.func_94530_a(stack, targetSlot)) continue;
                int l = slotStack.func_190916_E() + stack.func_190916_E();
                if (l <= (limit = targetSlot.func_178170_b(stack))) {
                    stack.func_190920_e(0);
                    slotStack.func_190920_e(l);
                    targetSlot.func_75218_e();
                    didSomething = true;
                    continue;
                }
                if (slotStack.func_190916_E() >= limit) continue;
                stack.func_190918_g(limit - slotStack.func_190916_E());
                slotStack.func_190920_e(limit);
                targetSlot.func_75218_e();
                didSomething = true;
            }
        }
        return didSomething;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean didSomething = false;
        for (int k = startIndex; k < endIndex; ++k) {
            Slot targetSlot = (Slot)this.field_75151_b.get(k);
            ItemStack slotStack = targetSlot.func_75211_c();
            if (!slotStack.func_190926_b() || !targetSlot.func_75214_a(stack) || !this.func_94530_a(stack, targetSlot)) continue;
            int limit = targetSlot.func_178170_b(stack);
            ItemStack stack2 = stack.func_77946_l();
            if (stack2.func_190916_E() > limit) {
                stack2.func_190920_e(limit);
                stack.func_190918_g(limit);
            } else {
                stack.func_190920_e(0);
            }
            targetSlot.func_75215_d(stack2);
            targetSlot.func_75218_e();
            didSomething = true;
            if (stack.func_190926_b()) break;
        }
        return didSomething;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    public void updateSlotPositions(int offset) {
        int start;
        Pair<Integer, Integer> range = this.containerStarts.get(this.currentContainer);
        for (int i = start = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            int index = (i - start) / 6 - offset;
            slot.field_75221_f = index >= 9 || index < 0 ? -10000 : 17 + 18 * index;
        }
    }

    public void changeContainer(int newContainer) {
        Slot slot;
        int i;
        this.currentContainer = newContainer;
        Pair<Integer, Integer> range = this.containerStarts.get(this.currentContainer);
        int start = (Integer)range.getLeft();
        int finish = (Integer)range.getRight();
        for (i = 10; i < this.subContainerSize + 10; ++i) {
            slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof BigSlot) || i >= start && i < finish) continue;
            this.hideSlot(slot);
        }
        for (i = start; i < finish; ++i) {
            slot = (Slot)this.field_75151_b.get(i);
            int row = (i - start) / 6;
            int column = (i - start) % 6;
            slot.field_75221_f = row >= 9 || row < 0 ? -10000 : 17 + 18 * row;
            int offsetx = this.needsScroll() ? 0 : 8;
            slot.field_75223_e = 18 * column - 125 + offsetx;
        }
    }

    public void updateLastRecipeFromServer(IRecipe<CraftingInventory> recipe) {
        this.lastRecipe = recipe;
        this.craftResult.func_70299_a(0, recipe != null ? recipe.func_77572_b((IInventory)this.craftMatrix) : ItemStack.field_190927_a);
    }

    public boolean needsScroll() {
        return this.getSlotCount() > 54;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getSlotCount() / 6.0);
    }

    public int getSlotCount() {
        if (this.containerStarts.isEmpty()) {
            return 0;
        }
        Pair<Integer, Integer> range = this.containerStarts.get(this.currentContainer);
        return (Integer)range.getRight() - (Integer)range.getLeft();
    }

    private void accept(IItemHandler handler) {
        if (this.containerStarts.size() == 0) {
            int left = 10;
            int right = handler.getSlots() + left;
            this.containerStarts.add((Pair<Integer, Integer>)Pair.of((Object)left, (Object)right));
            return;
        }
        int left = (Integer)this.containerStarts.get(this.containerStarts.size() - 1).getRight();
        int right = handler.getSlots() + left;
        this.containerStarts.add((Pair<Integer, Integer>)Pair.of((Object)left, (Object)right));
    }

    public NonNullList<ItemStack> getRemainingItems() {
        return this.lastRecipe != null && this.lastRecipe.func_77569_a((IInventory)this.craftMatrix, this.world) ? this.lastRecipe.func_179532_b((IInventory)this.craftMatrix) : this.craftMatrix.getStackList();
    }

    static {
        Method doubleSlabsGetTileEntity1 = null;
        if (ModList.get().isLoaded("doubleslabs")) {
            try {
                Class<?> doubleSlabsFlags = Class.forName("cjminecraft.doubleslabs.api.Flags");
                doubleSlabsGetTileEntity1 = doubleSlabsFlags.getDeclaredMethod("getTileEntityAtPos", BlockPos.class, IBlockReader.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                e.printStackTrace();
                doubleSlabsGetTileEntity1 = null;
            }
        }
        GET_TILE_ENTITY_METHOD = doubleSlabsGetTileEntity1;
    }
}

