/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.tfar.craftingstation.Configs;
import com.tfar.craftingstation.CraftingStationBlock;
import com.tfar.craftingstation.CraftingStationBlockEntity;
import com.tfar.craftingstation.CraftingStationContainer;
import com.tfar.craftingstation.CraftingStationSlabBlock;
import com.tfar.craftingstation.network.PacketHandler;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="craftingstation")
public class CraftingStation {
    public static final String MODID = "craftingstation";
    public static final ITag<TileEntityType<?>> blacklisted = ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (ResourceLocation)new ResourceLocation("craftingstation", "blacklisted"));
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Configs.Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public CraftingStation() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        IEventBus iEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        iEventBus.addListener(this::setup);
        iEventBus.addListener(this::enqueueIMC);
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.registerMessages(MODID);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"craftingtweaks", (String)"RegisterProvider", () -> {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74778_a("ContainerClass", CraftingStationContainer.class.getName());
            tagCompound.func_74778_a("AlignToGrid", "left");
            return tagCompound;
        });
    }

    static {
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Configs.Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (Configs.Server)specPair2.getLeft();
    }

    @ObjectHolder(value="craftingstation")
    public static class Objects {
        public static final Block crafting_station = null;
        public static final Block crafting_station_slab = null;
        public static final ContainerType<CraftingStationContainer> crafting_station_container = null;
        public static final TileEntityType<CraftingStationBlockEntity> crafting_station_tile = null;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void block(RegistryEvent.Register<Block> event) {
            AbstractBlock.Properties wood = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150462_ai);
            RegistryEvents.register(new CraftingStationBlock(wood), "crafting_station", event.getRegistry());
            RegistryEvents.register(new CraftingStationSlabBlock(wood), "crafting_station_slab", event.getRegistry());
        }

        @SubscribeEvent
        public static void item(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
            RegistryEvents.register(new BlockItem(Objects.crafting_station, properties), "crafting_station", event.getRegistry());
            RegistryEvents.register(new BlockItem(Objects.crafting_station_slab, properties), "crafting_station_slab", event.getRegistry());
        }

        @SubscribeEvent
        public static void container(RegistryEvent.Register<ContainerType<?>> event) {
            RegistryEvents.register(IForgeContainerType.create((windowId, inv, data) -> new CraftingStationContainer(windowId, inv, inv.field_70458_d.field_70170_p, data.func_179259_c())), "crafting_station_container", event.getRegistry());
        }

        @SubscribeEvent
        public static void tile(RegistryEvent.Register<TileEntityType<?>> event) {
            RegistryEvents.register(TileEntityType.Builder.func_223042_a(CraftingStationBlockEntity::new, (Block[])new Block[]{Objects.crafting_station, Objects.crafting_station_slab}).func_206865_a(null), "crafting_station_tile", event.getRegistry());
        }

        private static <T extends IForgeRegistryEntry<T>> void register(T obj, String name, IForgeRegistry<T> registry) {
            registry.register((IForgeRegistryEntry)obj.setRegistryName(new ResourceLocation(CraftingStation.MODID, name)));
        }
    }
}

