/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import lain.mods.cos.api.event.CosArmorDeathDrops;
import lain.mods.cos.impl.ModConfigs;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.ContainerCosArmor;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import lain.mods.cos.impl.network.packet.PacketSyncCosArmor;
import lain.mods.cos.impl.network.packet.PacketSyncHiddenFlags;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class InventoryManager {
    protected static final InventoryCosArmor Dummy = new InventoryCosArmor(){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isHidden(String modid, String identifier) {
            return false;
        }

        @Override
        public boolean isSkinArmor(int slot) {
            return false;
        }

        @Override
        protected void onContentsChanged(int slot) {
        }

        @Override
        protected void onLoad() {
        }

        @Override
        public boolean setHidden(String modid, String identifier, boolean set) {
            return false;
        }

        @Override
        public void setSkinArmor(int slot, boolean enabled) {
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        @Override
        public boolean setUpdateListener(InventoryCosArmor.ContentsChangeListener listener) {
            return false;
        }

        @Override
        public boolean setUpdateListener(InventoryCosArmor.HiddenFlagsChangeListener listener) {
            return false;
        }
    };
    protected static final Random RANDOM = new Random();
    protected final LoadingCache<UUID, InventoryCosArmor> CommonCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<UUID, InventoryCosArmor>(){

        public InventoryCosArmor load(UUID key) throws Exception {
            InventoryCosArmor inventory = new InventoryCosArmor();
            inventory.setUpdateListener((inv, slot) -> InventoryManager.this.onInventoryChanged(key, inv, slot));
            inventory.setUpdateListener((inv, modid, identifier) -> InventoryManager.this.onHiddenFlagsChanged(key, inv, modid, identifier));
            InventoryManager.this.loadInventory(key, inventory);
            return inventory;
        }
    });

    public static boolean checkIdentifier(String modid, String identifier) {
        if (modid == null || modid.isEmpty() || identifier == null || identifier.isEmpty() || !ModList.get().isLoaded(modid)) {
            return false;
        }
        return false;
    }

    public ContainerCosArmor createContainerClient(int windowId, PlayerInventory invPlayer, PacketBuffer extraData) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public InventoryCosArmor getCosArmorInventory(UUID uuid) {
        if (uuid == null) {
            return Dummy;
        }
        return (InventoryCosArmor)((Object)this.CommonCache.getUnchecked((Object)uuid));
    }

    @Nonnull
    public InventoryCosArmor getCosArmorInventoryClient(UUID uuid) {
        throw new UnsupportedOperationException();
    }

    protected File getDataFile(UUID uuid) {
        return new File(((MinecraftServer)LogicalSidedProvider.INSTANCE.get((LogicalSide)LogicalSide.SERVER)).field_240766_e_.getPlayerDataFolder(), uuid + ".cosarmor");
    }

    private void handlePlayerDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_70613_aW() && !event.getEntityLiving().func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c) && !((Boolean)ModConfigs.CosArmorKeepThroughDeath.get()).booleanValue()) {
            InventoryCosArmor inv = this.getCosArmorInventory(event.getEntityLiving().func_110124_au());
            if (MinecraftForge.EVENT_BUS.post((Event)new CosArmorDeathDrops((PlayerEntity)event.getEntityLiving(), inv))) {
                return;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i).func_77946_l();
                if (stack.func_190926_b()) continue;
                float fX = RANDOM.nextFloat() * 0.75f + 0.125f;
                float fY = RANDOM.nextFloat() * 0.75f;
                float fZ = RANDOM.nextFloat() * 0.75f + 0.125f;
                while (!stack.func_190926_b()) {
                    ItemEntity entity = new ItemEntity(event.getEntityLiving().func_130014_f_(), event.getEntityLiving().func_226277_ct_() + (double)fX, event.getEntityLiving().func_226278_cu_() + (double)fY, event.getEntityLiving().func_226281_cx_() + (double)fZ, stack.func_77979_a(RANDOM.nextInt(21) + 10));
                    entity.func_213293_j(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
                    event.getDrops().add(entity);
                }
                inv.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    private void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.CommonCache.invalidate((Object)event.getPlayer().func_110124_au());
        this.getCosArmorInventory(event.getPlayer().func_110124_au());
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            for (ServerPlayerEntity other : ((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_184103_al().func_181057_v()) {
                if (other == player) continue;
                UUID uuid = other.func_110124_au();
                InventoryCosArmor inv = this.getCosArmorInventory(uuid);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ModObjects.network.sendTo(new PacketSyncCosArmor(uuid, inv, i), player);
                }
                inv.forEachHidden((modid, identifier) -> ModObjects.network.sendTo(new PacketSyncHiddenFlags(uuid, inv, (String)modid, (String)identifier), player));
            }
        }
    }

    private void handlePlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getPlayer().func_110124_au();
        InventoryCosArmor inv = (InventoryCosArmor)((Object)this.CommonCache.getIfPresent((Object)uuid));
        if (inv != null) {
            this.saveInventory(uuid, inv);
            this.CommonCache.invalidate((Object)uuid);
        }
    }

    private void handleRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clearcosarmor").requires(s -> s.func_197034_c(2))).executes(s -> {
            int count = 0;
            ServerPlayerEntity player = ((CommandSource)s.getSource()).func_197035_h();
            InventoryCosArmor inv = this.getCosArmorInventory(player.func_110124_au());
            for (int i = 0; i < inv.getSlots(); ++i) {
                count += inv.extractItem(i, Integer.MAX_VALUE, false).func_190916_E();
            }
            ((CommandSource)s.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("cos.command.clearcosarmor.success.single", new Object[]{count, player.func_145748_c_()}), true);
            return count;
        })).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(s -> {
            int count = 0;
            Collection players = EntityArgument.func_197090_e((CommandContext)s, (String)"targets");
            for (ServerPlayerEntity player : players) {
                InventoryCosArmor inv = this.getCosArmorInventory(player.func_110124_au());
                for (int i = 0; i < inv.getSlots(); ++i) {
                    count += inv.extractItem(i, Integer.MAX_VALUE, false).func_190916_E();
                }
            }
            if (players.size() == 1) {
                ((CommandSource)s.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("cos.command.clearcosarmor.success.single", new Object[]{count, ((ServerPlayerEntity)players.iterator().next()).func_145748_c_()}), true);
            } else {
                ((CommandSource)s.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("cos.command.clearcosarmor.success.multiple", new Object[]{count, players.size()}), true);
            }
            return count;
        })));
        if (!((Boolean)ModConfigs.CosArmorDisableCosHatCommand.get()).booleanValue()) {
            event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"coshat").requires(s -> s.func_197034_c(0))).executes(s -> {
                ServerPlayerEntity player = ((CommandSource)s.getSource()).func_197035_h();
                InventoryCosArmor inv = this.getCosArmorInventory(player.func_110124_au());
                ItemStack stack1 = player.func_184582_a(EquipmentSlotType.MAINHAND);
                ItemStack stack2 = inv.getStackInSlot(3);
                player.func_184201_a(EquipmentSlotType.MAINHAND, stack2);
                inv.setStackInSlot(3, stack1);
                return 0;
            }));
        }
    }

    private void handleSaveToFile(PlayerEvent.SaveToFile event) {
        UUID uuid = UUID.fromString(event.getPlayerUUID());
        InventoryCosArmor inv = (InventoryCosArmor)((Object)this.CommonCache.getIfPresent((Object)uuid));
        if (inv != null) {
            this.saveInventory(uuid, inv);
        }
    }

    private void handleServerStopping(FMLServerStoppingEvent event) {
        ModObjects.logger.debug("Server is stopping... try to save all still loaded CosmeticArmor data");
        this.CommonCache.asMap().entrySet().forEach(e -> {
            ModObjects.logger.debug(e.getKey());
            this.saveInventory((UUID)e.getKey(), (InventoryCosArmor)((Object)((Object)e.getValue())));
        });
        this.CommonCache.invalidateAll();
    }

    protected void loadInventory(UUID uuid, InventoryCosArmor inventory) {
        if (inventory == Dummy) {
            return;
        }
        try {
            File file = this.getDataFile(uuid);
            if (file.exists()) {
                inventory.deserializeNBT(CompressedStreamTools.func_74797_a((File)file));
            }
        }
        catch (Throwable t) {
            ModObjects.logger.fatal("Failed to load CosmeticArmor data", t);
        }
    }

    protected void onHiddenFlagsChanged(UUID uuid, InventoryCosArmor inventory, String modid, String identifier) {
        ModObjects.network.sendToAll(new PacketSyncHiddenFlags(uuid, inventory, modid, identifier));
    }

    protected void onInventoryChanged(UUID uuid, InventoryCosArmor inventory, int slot) {
        ModObjects.network.sendToAll(new PacketSyncCosArmor(uuid, inventory, slot));
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerDrops);
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerLoggedOut);
        MinecraftForge.EVENT_BUS.addListener(this::handleSaveToFile);
        MinecraftForge.EVENT_BUS.addListener(this::handleRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::handleServerStopping);
    }

    public void registerEventsClient() {
        throw new UnsupportedOperationException();
    }

    protected void saveInventory(UUID uuid, InventoryCosArmor inventory) {
        if (inventory == Dummy) {
            return;
        }
        try {
            CompressedStreamTools.func_74795_b((CompoundNBT)inventory.serializeNBT(), (File)this.getDataFile(uuid));
        }
        catch (Throwable t) {
            ModObjects.logger.fatal("Failed to save CosmeticArmor data", t);
        }
    }
}

