/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModTabs;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WoodcutterItem
extends BlockItem {
    private static final ITextComponent DEFAULT_DESCRIPTION = new TranslationTextComponent("item.corail_woodcutter.woodcutter.desc").func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent ACCESS_FROM_INVENTORY = new TranslationTextComponent("item.corail_woodcutter.woodcutter.inventory").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC});

    public WoodcutterItem(Block woodcutterBlock) {
        super(woodcutterBlock, new Item.Properties().func_200916_a(ModTabs.mainTab).func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flagIn) {
        list.add(DEFAULT_DESCRIPTION);
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue()) {
            list.add(ACCESS_FROM_INVENTORY);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && hand == Hand.MAIN_HAND && player.func_225608_bj_()) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, p) -> new WoodcutterContainer(id, playerInventory), (ITextComponent)WoodcutterBlock.TRANSLATION));
            }
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (context.func_195999_j() != null && !(context.func_195999_j() instanceof FakePlayer) && context.func_221531_n() == Hand.MAIN_HAND && context.func_195999_j().func_225608_bj_() && this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a().func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && event.getPlayer() != null && !(event.getPlayer() instanceof FakePlayer) && event.getPlayer().func_225608_bj_() && ModBlocks.WOODCUTTER_ITEMS.contains((heldStack = event.getPlayer().func_184586_b(event.getHand())).func_77973_b())) {
            event.setCancellationResult(ActionResultType.PASS);
            event.setCanceled(true);
        }
    }
}

