/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;

@OnlyIn(value=Dist.CLIENT)
public class WoodcutterScreen
extends ContainerScreen<WoodcutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float sliderProgress;
    private boolean isSliderClicked;
    private int recipeIndexOffset;
    private boolean hasInput;

    public WoodcutterScreen(WoodcutterContainer containerIn, PlayerInventory playerInv, ITextComponent title) {
        super((Container)containerIn, playerInv, title);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (!(type != ClickType.PICKUP || slotId != 0 || mouseButton != 0 || slotIn == null || slotIn.field_75222_d != 0 || this.field_213127_e.func_70445_o().func_190926_b() || slotIn.func_75211_c().func_190926_b() || Container.func_195929_a((ItemStack)this.field_213127_e.func_70445_o(), (ItemStack)slotIn.func_75211_c()))) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTick);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, 8.0f, 4.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.sliderProgress);
        this.func_238474_b_(matrixStack, i + 119, j + 15 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.renderRecipeBackground(matrixStack, mouseX, mouseY, l, i1, j1);
        this.renderRecipeIcons(matrixStack, l, i1, j1);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int x, int y) {
        super.func_230459_a_(matrixStack, x, y);
        if (this.hasInput) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterContainer)this.field_147002_h).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.func_230457_a_(matrixStack, list.get(l).func_77571_b(), x, y);
            }
        }
    }

    private void renderRecipeBackground(MatrixStack matrixStack, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.recipeIndexOffset; i < scrollOffset && i < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((WoodcutterContainer)this.field_147002_h).getSelectedRecipe()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(matrixStack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipeIcons(MatrixStack matrixStack, int x, int y, int scrollOffset) {
        List<WoodcuttingRecipe> list = ((WoodcutterContainer)this.field_147002_h).getRecipeList();
        for (int i = this.recipeIndexOffset; i < scrollOffset && i < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            this.getMinecraft().func_175599_af().func_180450_b(list.get(i).func_77571_b(), k, i1);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int buttonId) {
        this.isSliderClicked = false;
        if (this.hasInput) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((WoodcutterContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.getMinecraft().field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.getMinecraft().field_71442_b.func_78756_a(((WoodcutterContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 14;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.isSliderClicked = true;
                this.sliderProgress = MathHelper.func_76131_a((float)((float)(mouseY - (double)j - 7.5) / 40.0f), (float)0.0f, (float)1.0f);
                this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, buttonId);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int buttonId, double dragX, double dragY) {
        if (this.isSliderClicked && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, buttonId, dragX, dragY);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_mouseScrolled_5_ / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasInput && ((WoodcutterContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    private int getHiddenRows() {
        return (((WoodcutterContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasInput = ((WoodcutterContainer)this.field_147002_h).hasItemsinInputSlot();
        if (!this.hasInput) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

