/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.MilkJarTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MilkJarBlock
extends BlockKitchen
implements IBucketPickupHandler {
    public static final String name = "milk_jar";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "milk_jar");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.8, (double)0.0, (double)4.8, (double)11.2, (double)8.0, (double)11.2);

    public MilkJarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f).func_200943_b(0.6f), registryName);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LOWERED});
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (MilkJarBlock.shouldBlockRenderLowered(world, pos)) {
            return SHAPE.func_197751_a(0.0, -0.05, 0.0);
        }
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        MilkJarTileEntity tileMilkJar = (MilkJarTileEntity)world.func_175625_s(pos);
        if (!heldItem.func_190926_b() && tileMilkJar != null) {
            if (heldItem.func_77973_b() == Items.field_151117_aB) {
                if (tileMilkJar.getMilkAmount() <= tileMilkJar.getMilkCapacity() - 1000.0f) {
                    tileMilkJar.fill(1000, IFluidHandler.FluidAction.EXECUTE);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Items.field_151133_ar) {
                if (tileMilkJar.getMilkAmount() >= 1000.0f) {
                    if (heldItem.func_190916_E() == 1) {
                        tileMilkJar.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151117_aB));
                        }
                    } else if (player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151117_aB))) {
                        tileMilkJar.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MilkJarTileEntity();
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MilkJarTileEntity && ((MilkJarTileEntity)tileEntity).getMilkAmount() >= 1000.0f) {
            int drained = ((MilkJarTileEntity)tileEntity).drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return drained >= 1000 ? Compat.getMilkFluid() : Fluids.field_204541_a;
        }
        return Fluids.field_204541_a;
    }
}

