/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.container.OvenContainer;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModTileEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.blay09.mods.cookingforblockheads.tile.util.EnergyStorageModifiable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.ArrayUtils;

public class OvenTileEntity
extends TileEntity
implements ITickableTileEntity,
IKitchenSmeltingProvider,
INamedContainerProvider,
IMutableNameable {
    private static final int COOK_TIME = 200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(20){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 3 ? OvenTileEntity.this.getSmeltingResult(stack).func_190926_b() : slot == 3 && !OvenTileEntity.isItemFuel(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                OvenTileEntity.this.slotCookTime[slot - 7] = 0;
            }
            OvenTileEntity.this.isDirty = true;
            OvenTileEntity.this.func_70296_d();
        }
    };
    private final EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(10000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                OvenTileEntity.this.func_70296_d();
            }
            return super.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!simulate) {
                OvenTileEntity.this.func_70296_d();
            }
            return super.extractEnergy(maxExtract, simulate);
        }
    };
    private final RangedWrapper itemHandlerInput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 0, 3);
    private final RangedWrapper itemHandlerFuel = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 3, 4);
    private final RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 4, 7);
    private final RangedWrapper itemHandlerProcessing = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 7, 16);
    private final RangedWrapper itemHandlerTools = new RangedWrapper((IItemHandlerModifiable)this.itemHandler, 16, 20);
    private final KitchenItemProvider itemProvider = new KitchenItemProvider((IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandlerTools, this.itemHandlerOutput}));
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 1, 2);
    private final LazyOptional<IKitchenItemProvider> itemProviderCap = LazyOptional.of(() -> this.itemProvider);
    private final LazyOptional<IKitchenSmeltingProvider> smeltingProviderCap = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyStorage> energyStorageCap = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> itemHandlerInputCap = LazyOptional.of(() -> this.itemHandlerInput);
    private final LazyOptional<IItemHandler> itemHandlerFuelCap = LazyOptional.of(() -> this.itemHandlerFuel);
    private final LazyOptional<IItemHandler> itemHandlerOutputCap = LazyOptional.of(() -> this.itemHandlerOutput);
    private ITextComponent customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private Direction facing;
    private ItemStackHandler singleSlotItemHandler = new ItemStackHandler(1);
    private RecipeWrapper singleSlotRecipeWrapper = new RecipeWrapper((IItemHandlerModifiable)this.singleSlotItemHandler);

    public OvenTileEntity() {
        super(ModTileEntities.oven);
        this.doorAnimator.setSoundEventOpen(ModSounds.ovenOpen);
        this.doorAnimator.setSoundEventClose(ModSounds.ovenClose);
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_73660_a() {
        BlockState state;
        if (this.isFirstTick && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModBlocks.oven) {
            this.facing = (Direction)state.func_177229_b((Property)OvenBlock.FACING);
            this.isFirstTick = false;
        }
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.extractEnergy(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemStack;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (int i = 0; i < this.itemHandlerFuel.getSlots(); ++i) {
                    ItemStack fuelItem = this.itemHandlerFuel.getStackInSlot(i);
                    if (fuelItem.func_190926_b()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)OvenTileEntity.getBurnTime(fuelItem) * (Double)CookingForBlockheadsConfig.COMMON.ovenFuelTimeMultiplier.get());
                    if (this.furnaceBurnTime == 0) break;
                    ItemStack containerItem = fuelItem.func_77973_b().getContainerItem(fuelItem);
                    fuelItem.func_190918_g(1);
                    if (fuelItem.func_190926_b()) {
                        this.itemHandlerFuel.setStackInSlot(i, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            int firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
                itemStack = this.itemHandlerProcessing.getStackInSlot(i);
                if (!itemStack.func_190926_b()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack smeltingResult;
                        double maxCookTime = 200.0 * (Double)CookingForBlockheadsConfig.COMMON.ovenCookTimeMultiplier.get();
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).func_190926_b()) continue;
                        ItemStack resultStack = smeltingResult.func_77946_l();
                        this.itemHandlerProcessing.setStackInSlot(i, resultStack);
                        MinecraftForge.EVENT_BUS.post((Event)new OvenCookedEvent(this.field_145850_b, this.field_174879_c, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                ItemStack transferStack = this.itemHandlerProcessing.getStackInSlot(firstTransferSlot);
                transferStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerOutput, (ItemStack)transferStack, (boolean)false);
                this.itemHandlerProcessing.setStackInSlot(firstTransferSlot, transferStack);
                if (transferStack.func_190926_b()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (int j = 0; j < this.itemHandlerInput.getSlots(); ++j) {
                    itemStack = this.itemHandlerInput.getStackInSlot(j);
                    if (itemStack.func_190926_b()) continue;
                    this.itemHandlerProcessing.setStackInSlot(firstEmptySlot, itemStack.func_77979_a(1));
                    if (itemStack.func_190916_E() > 0) break;
                    this.itemHandlerInput.setStackInSlot(j, ItemStack.field_190927_a);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.isDirty = true;
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult(itemStack);
        if (!result.func_190926_b()) {
            return result;
        }
        this.singleSlotItemHandler.setStackInSlot(0, itemStack);
        IRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this.singleSlotRecipeWrapper, this.field_145850_b).orElse(null);
        if (recipe != null && !(result = recipe.func_77571_b()).func_190926_b() && result.func_77973_b().func_219971_r()) {
            return result;
        }
        if (!result.func_190926_b() && CookingRegistry.isNonFoodRecipe(result)) {
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        if (((Boolean)CookingForBlockheadsConfig.COMMON.ovenRequiresCookingOil.get()).booleanValue()) {
            return itemStack.func_77973_b().getTags().contains(Compat.cookingOilTag);
        }
        return OvenTileEntity.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (((Boolean)CookingForBlockheadsConfig.COMMON.ovenRequiresCookingOil.get()).booleanValue() && itemStack.func_77973_b().getTags().contains(Compat.cookingOilTag)) {
            return 800;
        }
        int ret = itemStack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack, (int)(ret == -1 ? AbstractFurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : ret));
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.itemHandlerProcessing.getSlots(); ++i) {
            ItemStack cookingStack = this.itemHandlerProcessing.getStackInSlot(i);
            if (cookingStack.func_190926_b() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.currentItemBurnTime = tagCompound.func_74765_d("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.func_74759_k("CookTimes");
        this.hasPowerUpgrade = tagCompound.func_74767_n("HasPowerUpgrade");
        this.energyStorage.setEnergyStored(tagCompound.func_74762_e("EnergyStored"));
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tagCompound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.func_74783_a("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tagCompound.func_74757_a("HasPowerUpgrade", this.hasPowerUpgrade);
        tagCompound.func_74768_a("EnergyStored", this.energyStorage.getEnergyStored());
        if (this.customName != null) {
            tagCompound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tagCompound;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tagCompound = new CompoundNBT();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)OvenBlock.POWERED, (Comparable)Boolean.valueOf(hasPowerUpgrade)));
        this.func_70296_d();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        if (this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0) {
            return 1.0f;
        }
        return (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * (Double)CookingForBlockheadsConfig.COMMON.ovenCookTimeMultiplier.get());
    }

    @Override
    public ItemStack smeltItem(ItemStack itemStack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandlerInput, (ItemStack)itemStack, (boolean)false);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public ItemStack getToolItem(int i) {
        return this.itemHandlerTools.getStackInSlot(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.itemHandlerTools.setStackInSlot(i, itemStack);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.itemHandlerCap.cast();
            }
            if (!((Boolean)CookingForBlockheadsConfig.COMMON.disallowOvenAutomation.get()).booleanValue()) {
                switch (facing) {
                    case UP: {
                        return this.itemHandlerInputCap.cast();
                    }
                    case DOWN: {
                        return this.itemHandlerOutputCap.cast();
                    }
                }
                return this.itemHandlerFuelCap.cast();
            }
        }
        if (this.hasPowerUpgrade && capability == CapabilityEnergy.ENERGY) {
            return this.energyStorageCap.cast();
        }
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return this.itemProviderCap.cast();
        }
        if (capability == CapabilityKitchenSmeltingProvider.CAPABILITY) {
            return this.smeltingProviderCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public IItemHandler getInputHandler() {
        return this.itemHandlerInput;
    }

    public RangedWrapper getItemHandlerFuel() {
        return this.itemHandlerFuel;
    }

    public Direction getFacing() {
        return this.facing == null ? Direction.NORTH : this.facing;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new OvenContainer(i, playerInventory, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 1, 2));
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
        this.func_70296_d();
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Override
    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("container.cookingforblockheads.oven");
    }
}

