/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.items;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.crafting.RecipeWandUpgrade;
import thetadev.constructionwand.items.core.ItemCoreAngel;
import thetadev.constructionwand.items.core.ItemCoreDestruction;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.items.wand.ItemWandBasic;
import thetadev.constructionwand.items.wand.ItemWandInfinity;

@Mod.EventBusSubscriber(modid="constructionwand", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final Item WAND_STONE = new ItemWandBasic("stone_wand", ModItems.propWand(), (IItemTier)ItemTier.STONE);
    public static final Item WAND_IRON = new ItemWandBasic("iron_wand", ModItems.propWand(), (IItemTier)ItemTier.IRON);
    public static final Item WAND_DIAMOND = new ItemWandBasic("diamond_wand", ModItems.propWand(), (IItemTier)ItemTier.DIAMOND);
    public static final Item WAND_INFINITY = new ItemWandInfinity("infinity_wand", ModItems.propWand());
    public static final Item CORE_ANGEL = new ItemCoreAngel("core_angel", ModItems.propUpgrade());
    public static final Item CORE_DESTRUCTION = new ItemCoreDestruction("core_destruction", ModItems.propUpgrade());
    public static final Item[] WANDS = new Item[]{WAND_STONE, WAND_IRON, WAND_DIAMOND, WAND_INFINITY};
    public static final Item[] CORES = new Item[]{CORE_ANGEL, CORE_DESTRUCTION};
    public static final HashSet<Item> ALL_ITEMS = new HashSet();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])WANDS);
        ALL_ITEMS.addAll(Arrays.asList(WANDS));
        ModItems.registerItem((IForgeRegistry<Item>)r, CORE_ANGEL);
        ModItems.registerItem((IForgeRegistry<Item>)r, CORE_DESTRUCTION);
    }

    public static Item.Properties propWand() {
        return new Item.Properties().func_200916_a(ItemGroup.field_78040_i);
    }

    private static Item.Properties propUpgrade() {
        return new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1);
    }

    private static void registerItem(IForgeRegistry<Item> reg, Item item) {
        reg.register((IForgeRegistryEntry)item);
        ALL_ITEMS.add(item);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModItems.register(r, "wand_upgrade", RecipeWandUpgrade.SERIALIZER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModelProperties() {
        for (Item item : WANDS) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)ConstructionWand.loc("using_core"), (stack, world, entity) -> entity == null || !(stack.func_77973_b() instanceof ItemWand) ? 0.0f : (((IWandCore)new WandOptions((ItemStack)stack).cores.get()).getColor() > -1 ? 1.0f : 0.0f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        for (Item item : WANDS) {
            colors.func_199877_a((stack, layer) -> layer == 1 && stack.func_77973_b() instanceof ItemWand ? ((IWandCore)new WandOptions((ItemStack)stack).cores.get()).getColor() : -1, new IItemProvider[]{item});
        }
    }

    private static <V extends IForgeRegistryEntry<V>> void register(IForgeRegistry<V> reg, String name, IForgeRegistryEntry<V> thing) {
        reg.register((IForgeRegistryEntry)thing.setRegistryName(ConstructionWand.loc(name)));
    }
}

