/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.integrations.jei;

import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import thetadev.constructionwand.basics.ConfigClient;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.items.ModItems;

@JeiPlugin
public class ConstructionWandJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("constructionwand", "constructionwand");
    private static final String baseKey = "constructionwand.description.";
    private static final String baseKeyItem = "item.constructionwand.";

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    private ITextComponent keyComboComponent(boolean shiftOpt, ITextComponent optkeyComponent) {
        String key = shiftOpt ? "sneak_opt" : "sneak";
        return new TranslationTextComponent("constructionwand.description.key." + key, new Object[]{optkeyComponent}).func_240699_a_(TextFormatting.BLUE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IFormattableTextComponent optkeyComponent = new TranslationTextComponent(InputMappings.func_197954_a((int)((Integer)ConfigClient.OPT_KEY.get()), (int)-1).func_197935_d()).func_240699_a_(TextFormatting.BLUE);
        ITextComponent wandModeComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_MODE.get(), (ITextComponent)optkeyComponent);
        ITextComponent wandGuiComponent = this.keyComboComponent((Boolean)ConfigClient.SHIFTOPT_GUI.get(), (ITextComponent)optkeyComponent);
        for (Item wand : ModItems.WANDS) {
            ConfigServer.WandProperties wandProperties = ConfigServer.getWandProperties(wand);
            String durabilityKey = wand == ModItems.WAND_INFINITY ? "unlimited" : "limited";
            TranslationTextComponent durabilityComponent = new TranslationTextComponent("constructionwand.description.durability." + durabilityKey, new Object[]{wandProperties.getDurability()});
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)wand), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent("constructionwand.description.wand", new Object[]{new TranslationTextComponent(baseKeyItem + wand.getRegistryName().func_110623_a()), wandProperties.getLimit(), durabilityComponent, optkeyComponent, wandModeComponent, wandGuiComponent})});
        }
        for (Item core : ModItems.CORES) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)core), VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent(baseKey + core.getRegistryName().func_110623_a()), new TranslationTextComponent("constructionwand.description.core", new Object[]{wandModeComponent})});
        }
    }
}

